package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TuneDConfigBuilder extends TuneDConfigFluent<TuneDConfigBuilder> implements VisitableBuilder<TuneDConfig,TuneDConfigBuilder>{
  public TuneDConfigBuilder() {
    this(new TuneDConfig());
  }
  
  public TuneDConfigBuilder(TuneDConfigFluent<?> fluent) {
    this(fluent, new TuneDConfig());
  }
  
  public TuneDConfigBuilder(TuneDConfigFluent<?> fluent,TuneDConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TuneDConfigBuilder(TuneDConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TuneDConfigFluent<?> fluent;
  
  public TuneDConfig build() {
    TuneDConfig buildable = new TuneDConfig(fluent.getReapplySysctl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}