package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TunedSpecFluent<A extends TunedSpecFluent<A>> extends BaseFluent<A>{
  public TunedSpecFluent() {
  }
  
  public TunedSpecFluent(TunedSpec instance) {
    this.copyInstance(instance);
  }
  private String managementState;
  private ArrayList<TunedProfileBuilder> profile = new ArrayList<TunedProfileBuilder>();
  private ArrayList<TunedRecommendBuilder> recommend = new ArrayList<TunedRecommendBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TunedSpec instance) {
    instance = (instance != null ? instance : new TunedSpec());
    if (instance != null) {
          this.withManagementState(instance.getManagementState());
          this.withProfile(instance.getProfile());
          this.withRecommend(instance.getRecommend());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getManagementState() {
    return this.managementState;
  }
  
  public A withManagementState(String managementState) {
    this.managementState = managementState;
    return (A) this;
  }
  
  public boolean hasManagementState() {
    return this.managementState != null;
  }
  
  public A addToProfile(int index,TunedProfile item) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    TunedProfileBuilder builder = new TunedProfileBuilder(item);
    if (index < 0 || index >= profile.size()) { _visitables.get("profile").add(builder); profile.add(builder); } else { _visitables.get("profile").add(index, builder); profile.add(index, builder);}
    return (A)this;
  }
  
  public A setToProfile(int index,TunedProfile item) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    TunedProfileBuilder builder = new TunedProfileBuilder(item);
    if (index < 0 || index >= profile.size()) { _visitables.get("profile").add(builder); profile.add(builder); } else { _visitables.get("profile").set(index, builder); profile.set(index, builder);}
    return (A)this;
  }
  
  public A addToProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... items) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").add(builder);this.profile.add(builder);} return (A)this;
  }
  
  public A addAllToProfile(Collection<TunedProfile> items) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").add(builder);this.profile.add(builder);} return (A)this;
  }
  
  public A removeFromProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... items) {
    if (this.profile == null) return (A)this;
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").remove(builder); this.profile.remove(builder);} return (A)this;
  }
  
  public A removeAllFromProfile(Collection<TunedProfile> items) {
    if (this.profile == null) return (A)this;
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").remove(builder); this.profile.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromProfile(Predicate<TunedProfileBuilder> predicate) {
    if (profile == null) return (A) this;
    final Iterator<TunedProfileBuilder> each = profile.iterator();
    final List visitables = _visitables.get("profile");
    while (each.hasNext()) {
      TunedProfileBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TunedProfile> buildProfile() {
    return this.profile != null ? build(profile) : null;
  }
  
  public TunedProfile buildProfile(int index) {
    return this.profile.get(index).build();
  }
  
  public TunedProfile buildFirstProfile() {
    return this.profile.get(0).build();
  }
  
  public TunedProfile buildLastProfile() {
    return this.profile.get(profile.size() - 1).build();
  }
  
  public TunedProfile buildMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
      for (TunedProfileBuilder item : profile) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
      for (TunedProfileBuilder item : profile) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withProfile(List<TunedProfile> profile) {
    if (this.profile != null) {
      this._visitables.get("profile").clear();
    }
    if (profile != null) {
        this.profile = new ArrayList();
        for (TunedProfile item : profile) {
          this.addToProfile(item);
        }
    } else {
      this.profile = null;
    }
    return (A) this;
  }
  
  public A withProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... profile) {
    if (this.profile != null) {
        this.profile.clear();
        _visitables.remove("profile");
    }
    if (profile != null) {
      for (TunedProfile item : profile) {
        this.addToProfile(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasProfile() {
    return this.profile != null && !this.profile.isEmpty();
  }
  
  public A addNewProfile(String data,String name) {
    return (A)addToProfile(new TunedProfile(data, name));
  }
  
  public ProfileNested<A> addNewProfile() {
    return new ProfileNested(-1, null);
  }
  
  public ProfileNested<A> addNewProfileLike(TunedProfile item) {
    return new ProfileNested(-1, item);
  }
  
  public ProfileNested<A> setNewProfileLike(int index,TunedProfile item) {
    return new ProfileNested(index, item);
  }
  
  public ProfileNested<A> editProfile(int index) {
    if (profile.size() <= index) throw new RuntimeException("Can't edit profile. Index exceeds size.");
    return setNewProfileLike(index, buildProfile(index));
  }
  
  public ProfileNested<A> editFirstProfile() {
    if (profile.size() == 0) throw new RuntimeException("Can't edit first profile. The list is empty.");
    return setNewProfileLike(0, buildProfile(0));
  }
  
  public ProfileNested<A> editLastProfile() {
    int index = profile.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last profile. The list is empty.");
    return setNewProfileLike(index, buildProfile(index));
  }
  
  public ProfileNested<A> editMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
    int index = -1;
    for (int i=0;i<profile.size();i++) { 
    if (predicate.test(profile.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching profile. No match found.");
    return setNewProfileLike(index, buildProfile(index));
  }
  
  public A addToRecommend(int index,TunedRecommend item) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
    if (index < 0 || index >= recommend.size()) { _visitables.get("recommend").add(builder); recommend.add(builder); } else { _visitables.get("recommend").add(index, builder); recommend.add(index, builder);}
    return (A)this;
  }
  
  public A setToRecommend(int index,TunedRecommend item) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
    if (index < 0 || index >= recommend.size()) { _visitables.get("recommend").add(builder); recommend.add(builder); } else { _visitables.get("recommend").set(index, builder); recommend.set(index, builder);}
    return (A)this;
  }
  
  public A addToRecommend(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend... items) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").add(builder);this.recommend.add(builder);} return (A)this;
  }
  
  public A addAllToRecommend(Collection<TunedRecommend> items) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").add(builder);this.recommend.add(builder);} return (A)this;
  }
  
  public A removeFromRecommend(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend... items) {
    if (this.recommend == null) return (A)this;
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").remove(builder); this.recommend.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRecommend(Collection<TunedRecommend> items) {
    if (this.recommend == null) return (A)this;
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").remove(builder); this.recommend.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRecommend(Predicate<TunedRecommendBuilder> predicate) {
    if (recommend == null) return (A) this;
    final Iterator<TunedRecommendBuilder> each = recommend.iterator();
    final List visitables = _visitables.get("recommend");
    while (each.hasNext()) {
      TunedRecommendBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TunedRecommend> buildRecommend() {
    return this.recommend != null ? build(recommend) : null;
  }
  
  public TunedRecommend buildRecommend(int index) {
    return this.recommend.get(index).build();
  }
  
  public TunedRecommend buildFirstRecommend() {
    return this.recommend.get(0).build();
  }
  
  public TunedRecommend buildLastRecommend() {
    return this.recommend.get(recommend.size() - 1).build();
  }
  
  public TunedRecommend buildMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
      for (TunedRecommendBuilder item : recommend) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
      for (TunedRecommendBuilder item : recommend) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRecommend(List<TunedRecommend> recommend) {
    if (this.recommend != null) {
      this._visitables.get("recommend").clear();
    }
    if (recommend != null) {
        this.recommend = new ArrayList();
        for (TunedRecommend item : recommend) {
          this.addToRecommend(item);
        }
    } else {
      this.recommend = null;
    }
    return (A) this;
  }
  
  public A withRecommend(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend... recommend) {
    if (this.recommend != null) {
        this.recommend.clear();
        _visitables.remove("recommend");
    }
    if (recommend != null) {
      for (TunedRecommend item : recommend) {
        this.addToRecommend(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRecommend() {
    return this.recommend != null && !this.recommend.isEmpty();
  }
  
  public RecommendNested<A> addNewRecommend() {
    return new RecommendNested(-1, null);
  }
  
  public RecommendNested<A> addNewRecommendLike(TunedRecommend item) {
    return new RecommendNested(-1, item);
  }
  
  public RecommendNested<A> setNewRecommendLike(int index,TunedRecommend item) {
    return new RecommendNested(index, item);
  }
  
  public RecommendNested<A> editRecommend(int index) {
    if (recommend.size() <= index) throw new RuntimeException("Can't edit recommend. Index exceeds size.");
    return setNewRecommendLike(index, buildRecommend(index));
  }
  
  public RecommendNested<A> editFirstRecommend() {
    if (recommend.size() == 0) throw new RuntimeException("Can't edit first recommend. The list is empty.");
    return setNewRecommendLike(0, buildRecommend(0));
  }
  
  public RecommendNested<A> editLastRecommend() {
    int index = recommend.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last recommend. The list is empty.");
    return setNewRecommendLike(index, buildRecommend(index));
  }
  
  public RecommendNested<A> editMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
    int index = -1;
    for (int i=0;i<recommend.size();i++) { 
    if (predicate.test(recommend.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching recommend. No match found.");
    return setNewRecommendLike(index, buildRecommend(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TunedSpecFluent that = (TunedSpecFluent) o;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;
    if (!java.util.Objects.equals(profile, that.profile)) return false;
    if (!java.util.Objects.equals(recommend, that.recommend)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(managementState,  profile,  recommend,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (profile != null && !profile.isEmpty()) { sb.append("profile:"); sb.append(profile + ","); }
    if (recommend != null && !recommend.isEmpty()) { sb.append("recommend:"); sb.append(recommend + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ProfileNested<N> extends TunedProfileFluent<ProfileNested<N>> implements Nested<N>{
    ProfileNested(int index,TunedProfile item) {
      this.index = index;
      this.builder = new TunedProfileBuilder(this, item);
    }
    TunedProfileBuilder builder;
    int index;
    
    public N and() {
      return (N) TunedSpecFluent.this.setToProfile(index,builder.build());
    }
    
    public N endProfile() {
      return and();
    }
    
  
  }
  public class RecommendNested<N> extends TunedRecommendFluent<RecommendNested<N>> implements Nested<N>{
    RecommendNested(int index,TunedRecommend item) {
      this.index = index;
      this.builder = new TunedRecommendBuilder(this, item);
    }
    TunedRecommendBuilder builder;
    int index;
    
    public N and() {
      return (N) TunedSpecFluent.this.setToRecommend(index,builder.build());
    }
    
    public N endRecommend() {
      return and();
    }
    
  
  }

}