package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TunedStatusBuilder extends TunedStatusFluent<TunedStatusBuilder> implements VisitableBuilder<TunedStatus,TunedStatusBuilder>{
  public TunedStatusBuilder() {
    this(new TunedStatus());
  }
  
  public TunedStatusBuilder(TunedStatusFluent<?> fluent) {
    this(fluent, new TunedStatus());
  }
  
  public TunedStatusBuilder(TunedStatusFluent<?> fluent,TunedStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TunedStatusBuilder(TunedStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TunedStatusFluent<?> fluent;
  
  public TunedStatus build() {
    TunedStatus buildable = new TunedStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}