package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TunedRecommendFluentImpl<A extends TunedRecommendFluent<A>> extends BaseFluent<A> implements TunedRecommendFluent<A>{
  public TunedRecommendFluentImpl() {
  }
  public TunedRecommendFluentImpl(TunedRecommend instance) {
    if (instance != null) {
      this.withMachineConfigLabels(instance.getMachineConfigLabels());
      this.withMatch(instance.getMatch());
      this.withOperand(instance.getOperand());
      this.withPriority(instance.getPriority());
      this.withProfile(instance.getProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,String> machineConfigLabels;
  private ArrayList<TunedMatchBuilder> match = new ArrayList<TunedMatchBuilder>();
  private OperandConfigBuilder operand;
  private Long priority;
  private String profile;
  private Map<String,Object> additionalProperties;
  public A addToMachineConfigLabels(String key,String value) {
    if(this.machineConfigLabels == null && key != null && value != null) { this.machineConfigLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.machineConfigLabels.put(key, value);} return (A)this;
  }
  public A addToMachineConfigLabels(Map<String,String> map) {
    if(this.machineConfigLabels == null && map != null) { this.machineConfigLabels = new LinkedHashMap(); }
    if(map != null) { this.machineConfigLabels.putAll(map);} return (A)this;
  }
  public A removeFromMachineConfigLabels(String key) {
    if(this.machineConfigLabels == null) { return (A) this; }
    if(key != null && this.machineConfigLabels != null) {this.machineConfigLabels.remove(key);} return (A)this;
  }
  public A removeFromMachineConfigLabels(Map<String,String> map) {
    if(this.machineConfigLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.machineConfigLabels != null){this.machineConfigLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getMachineConfigLabels() {
    return this.machineConfigLabels;
  }
  public <K,V>A withMachineConfigLabels(Map<String,String> machineConfigLabels) {
    if (machineConfigLabels == null) { this.machineConfigLabels =  null;} else {this.machineConfigLabels = new LinkedHashMap(machineConfigLabels);} return (A) this;
  }
  public Boolean hasMachineConfigLabels() {
    return this.machineConfigLabels != null;
  }
  public A addToMatch(int index,TunedMatch item) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    TunedMatchBuilder builder = new TunedMatchBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").add(index, builder); match.add(index, builder);}
    return (A)this;
  }
  public A setToMatch(int index,TunedMatch item) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    TunedMatchBuilder builder = new TunedMatchBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").set(index, builder); match.set(index, builder);}
    return (A)this;
  }
  public A addToMatch(io.fabric8.openshift.api.model.tuned.v1.TunedMatch... items) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A addAllToMatch(Collection<TunedMatch> items) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A removeFromMatch(io.fabric8.openshift.api.model.tuned.v1.TunedMatch... items) {
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatch(Collection<TunedMatch> items) {
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatch(Predicate<TunedMatchBuilder> predicate) {
    if (match == null) return (A) this;
    final Iterator<TunedMatchBuilder> each = match.iterator();
    final List visitables = _visitables.get("match");
    while (each.hasNext()) {
      TunedMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatch instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TunedMatch> getMatch() {
    return match != null ? build(match) : null;
  }
  public List<TunedMatch> buildMatch() {
    return match != null ? build(match) : null;
  }
  public TunedMatch buildMatch(int index) {
    return this.match.get(index).build();
  }
  public TunedMatch buildFirstMatch() {
    return this.match.get(0).build();
  }
  public TunedMatch buildLastMatch() {
    return this.match.get(match.size() - 1).build();
  }
  public TunedMatch buildMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
    for (TunedMatchBuilder item: match) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
    for (TunedMatchBuilder item: match) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatch(List<TunedMatch> match) {
    if (this.match != null) { _visitables.get("match").clear();}
    if (match != null) {this.match = new ArrayList(); for (TunedMatch item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
  }
  public A withMatch(io.fabric8.openshift.api.model.tuned.v1.TunedMatch... match) {
    if (this.match != null) {this.match.clear(); _visitables.remove("match"); }
    if (match != null) {for (TunedMatch item :match){ this.addToMatch(item);}} return (A) this;
  }
  public Boolean hasMatch() {
    return match != null && !match.isEmpty();
  }
  public TunedRecommendFluentImpl.MatchNested<A> addNewMatch() {
    return new TunedRecommendFluentImpl.MatchNestedImpl();
  }
  public TunedRecommendFluentImpl.MatchNested<A> addNewMatchLike(TunedMatch item) {
    return new TunedRecommendFluentImpl.MatchNestedImpl(-1, item);
  }
  public TunedRecommendFluentImpl.MatchNested<A> setNewMatchLike(int index,TunedMatch item) {
    return new TunedRecommendFluentImpl.MatchNestedImpl(index, item);
  }
  public TunedRecommendFluentImpl.MatchNested<A> editMatch(int index) {
    if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public TunedRecommendFluentImpl.MatchNested<A> editFirstMatch() {
    if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  public TunedRecommendFluentImpl.MatchNested<A> editLastMatch() {
    int index = match.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public TunedRecommendFluentImpl.MatchNested<A> editMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<match.size();i++) { 
    if (predicate.test(match.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  /**
   * This method has been deprecated, please use method buildOperand instead.
   * @return The buildable object.
   */
  @Deprecated
  public OperandConfig getOperand() {
    return this.operand!=null ?this.operand.build():null;
  }
  public OperandConfig buildOperand() {
    return this.operand!=null ?this.operand.build():null;
  }
  public A withOperand(OperandConfig operand) {
    _visitables.get("operand").remove(this.operand);
    if (operand!=null){ this.operand= new OperandConfigBuilder(operand); _visitables.get("operand").add(this.operand);} else { this.operand = null; _visitables.get("operand").remove(this.operand); } return (A) this;
  }
  public Boolean hasOperand() {
    return this.operand != null;
  }
  public A withNewOperand(Boolean debug) {
    return (A)withOperand(new OperandConfig(debug));
  }
  public TunedRecommendFluentImpl.OperandNested<A> withNewOperand() {
    return new TunedRecommendFluentImpl.OperandNestedImpl();
  }
  public TunedRecommendFluentImpl.OperandNested<A> withNewOperandLike(OperandConfig item) {
    return new TunedRecommendFluentImpl.OperandNestedImpl(item);
  }
  public TunedRecommendFluentImpl.OperandNested<A> editOperand() {
    return withNewOperandLike(getOperand());
  }
  public TunedRecommendFluentImpl.OperandNested<A> editOrNewOperand() {
    return withNewOperandLike(getOperand() != null ? getOperand(): new OperandConfigBuilder().build());
  }
  public TunedRecommendFluentImpl.OperandNested<A> editOrNewOperandLike(OperandConfig item) {
    return withNewOperandLike(getOperand() != null ? getOperand(): item);
  }
  public Long getPriority() {
    return this.priority;
  }
  public A withPriority(Long priority) {
    this.priority=priority; return (A) this;
  }
  public Boolean hasPriority() {
    return this.priority != null;
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public Boolean hasProfile() {
    return this.profile != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TunedRecommendFluentImpl that = (TunedRecommendFluentImpl) o;
    if (!java.util.Objects.equals(machineConfigLabels, that.machineConfigLabels)) return false;

    if (!java.util.Objects.equals(match, that.match)) return false;

    if (!java.util.Objects.equals(operand, that.operand)) return false;

    if (!java.util.Objects.equals(priority, that.priority)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(machineConfigLabels,  match,  operand,  priority,  profile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (machineConfigLabels != null && !machineConfigLabels.isEmpty()) { sb.append("machineConfigLabels:"); sb.append(machineConfigLabels + ","); }
    if (match != null) { sb.append("match:"); sb.append(match + ","); }
    if (operand != null) { sb.append("operand:"); sb.append(operand + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MatchNestedImpl<N> extends TunedMatchFluentImpl<TunedRecommendFluentImpl.MatchNested<N>> implements TunedRecommendFluentImpl.MatchNested<N>,Nested<N>{
    MatchNestedImpl(int index,TunedMatch item) {
      this.index = index;
      this.builder = new TunedMatchBuilder(this, item);
    }
    MatchNestedImpl() {
      this.index = -1;
      this.builder = new TunedMatchBuilder(this);
    }
    TunedMatchBuilder builder;
    int index;
    public N and() {
      return (N) TunedRecommendFluentImpl.this.setToMatch(index,builder.build());
    }
    public N endMatch() {
      return and();
    }
    
  }
  class OperandNestedImpl<N> extends OperandConfigFluentImpl<TunedRecommendFluentImpl.OperandNested<N>> implements TunedRecommendFluentImpl.OperandNested<N>,Nested<N>{
    OperandNestedImpl(OperandConfig item) {
      this.builder = new OperandConfigBuilder(this, item);
    }
    OperandNestedImpl() {
      this.builder = new OperandConfigBuilder(this);
    }
    OperandConfigBuilder builder;
    public N and() {
      return (N) TunedRecommendFluentImpl.this.withOperand(builder.build());
    }
    public N endOperand() {
      return and();
    }
    
  }
  
}