package io.fabric8.openshift.api.model.tuned.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProfileConfigFluent<A extends ProfileConfigFluent<A>> extends BaseFluent<A>{
  public ProfileConfigFluent() {
  }
  
  public ProfileConfigFluent(ProfileConfig instance) {
    this.copyInstance(instance);
  }
  private Boolean debug;
  private String providerName;
  private TuneDConfigBuilder tunedConfig;
  private String tunedProfile;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProfileConfig instance) {
    instance = (instance != null ? instance : new ProfileConfig());
    if (instance != null) {
          this.withDebug(instance.getDebug());
          this.withProviderName(instance.getProviderName());
          this.withTunedConfig(instance.getTunedConfig());
          this.withTunedProfile(instance.getTunedProfile());
          this.withDebug(instance.getDebug());
          this.withProviderName(instance.getProviderName());
          this.withTunedConfig(instance.getTunedConfig());
          this.withTunedProfile(instance.getTunedProfile());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getDebug() {
    return this.debug;
  }
  
  public A withDebug(Boolean debug) {
    this.debug = debug;
    return (A) this;
  }
  
  public boolean hasDebug() {
    return this.debug != null;
  }
  
  public String getProviderName() {
    return this.providerName;
  }
  
  public A withProviderName(String providerName) {
    this.providerName = providerName;
    return (A) this;
  }
  
  public boolean hasProviderName() {
    return this.providerName != null;
  }
  
  public TuneDConfig buildTunedConfig() {
    return this.tunedConfig != null ? this.tunedConfig.build() : null;
  }
  
  public A withTunedConfig(TuneDConfig tunedConfig) {
    this._visitables.remove(this.tunedConfig);
    if (tunedConfig != null) {
        this.tunedConfig = new TuneDConfigBuilder(tunedConfig);
        this._visitables.get("tunedConfig").add(this.tunedConfig);
    } else {
        this.tunedConfig = null;
        this._visitables.get("tunedConfig").remove(this.tunedConfig);
    }
    return (A) this;
  }
  
  public boolean hasTunedConfig() {
    return this.tunedConfig != null;
  }
  
  public A withNewTunedConfig(Boolean reapplySysctl) {
    return (A)withTunedConfig(new TuneDConfig(reapplySysctl));
  }
  
  public TunedConfigNested<A> withNewTunedConfig() {
    return new TunedConfigNested(null);
  }
  
  public TunedConfigNested<A> withNewTunedConfigLike(TuneDConfig item) {
    return new TunedConfigNested(item);
  }
  
  public TunedConfigNested<A> editTunedConfig() {
    return withNewTunedConfigLike(java.util.Optional.ofNullable(buildTunedConfig()).orElse(null));
  }
  
  public TunedConfigNested<A> editOrNewTunedConfig() {
    return withNewTunedConfigLike(java.util.Optional.ofNullable(buildTunedConfig()).orElse(new TuneDConfigBuilder().build()));
  }
  
  public TunedConfigNested<A> editOrNewTunedConfigLike(TuneDConfig item) {
    return withNewTunedConfigLike(java.util.Optional.ofNullable(buildTunedConfig()).orElse(item));
  }
  
  public String getTunedProfile() {
    return this.tunedProfile;
  }
  
  public A withTunedProfile(String tunedProfile) {
    this.tunedProfile = tunedProfile;
    return (A) this;
  }
  
  public boolean hasTunedProfile() {
    return this.tunedProfile != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProfileConfigFluent that = (ProfileConfigFluent) o;
    if (!java.util.Objects.equals(debug, that.debug)) return false;
    if (!java.util.Objects.equals(providerName, that.providerName)) return false;
    if (!java.util.Objects.equals(tunedConfig, that.tunedConfig)) return false;
    if (!java.util.Objects.equals(tunedProfile, that.tunedProfile)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(debug,  providerName,  tunedConfig,  tunedProfile,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (debug != null) { sb.append("debug:"); sb.append(debug + ","); }
    if (providerName != null) { sb.append("providerName:"); sb.append(providerName + ","); }
    if (tunedConfig != null) { sb.append("tunedConfig:"); sb.append(tunedConfig + ","); }
    if (tunedProfile != null) { sb.append("tunedProfile:"); sb.append(tunedProfile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDebug() {
    return withDebug(true);
  }
  public class TunedConfigNested<N> extends TuneDConfigFluent<TunedConfigNested<N>> implements Nested<N>{
    TunedConfigNested(TuneDConfig item) {
      this.builder = new TuneDConfigBuilder(this, item);
    }
    TuneDConfigBuilder builder;
    
    public N and() {
      return (N) ProfileConfigFluent.this.withTunedConfig(builder.build());
    }
    
    public N endTunedConfig() {
      return and();
    }
    
  
  }

}