package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProfileConfigBuilder extends ProfileConfigFluent<ProfileConfigBuilder> implements VisitableBuilder<ProfileConfig,ProfileConfigBuilder>{
  public ProfileConfigBuilder() {
    this(new ProfileConfig());
  }
  
  public ProfileConfigBuilder(ProfileConfigFluent<?> fluent) {
    this(fluent, new ProfileConfig());
  }
  
  public ProfileConfigBuilder(ProfileConfigFluent<?> fluent,ProfileConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProfileConfigBuilder(ProfileConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProfileConfigFluent<?> fluent;
  
  public ProfileConfig build() {
    ProfileConfig buildable = new ProfileConfig(fluent.getDebug(),fluent.getProviderName(),fluent.buildTunedConfig(),fluent.getTunedProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}