package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public class PolicyRuleFluentImpl<A extends PolicyRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PolicyRuleFluent<A>{

    private List<String> apiGroups = new ArrayList<String>();
    private VisitableBuilder<? extends HasMetadata,?> attributeRestrictions;
    private List<String> nonResourceURLs = new ArrayList<String>();
    private List<String> resourceNames = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();

    public PolicyRuleFluentImpl(){
    }
    public PolicyRuleFluentImpl(PolicyRule instance){
            this.withApiGroups(instance.getApiGroups()); 
            this.withAttributeRestrictions(instance.getAttributeRestrictions()); 
            this.withNonResourceURLs(instance.getNonResourceURLs()); 
            this.withResourceNames(instance.getResourceNames()); 
            this.withResources(instance.getResources()); 
            this.withVerbs(instance.getVerbs()); 
    }

    public A addToApiGroups(int index,String item){
            if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
            this.apiGroups.add(index, item);
            return (A)this;
    }

    public A setToApiGroups(int index,String item){
            if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
            this.apiGroups.set(index, item); return (A)this;
    }

    public A addToApiGroups(String... items){
            if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
            for (String item : items) {this.apiGroups.add(item);} return (A)this;
    }

    public A addAllToApiGroups(Collection<String> items){
            if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
            for (String item : items) {this.apiGroups.add(item);} return (A)this;
    }

    public A removeFromApiGroups(String... items){
            for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromApiGroups(Collection<String> items){
            for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
    }

    public List<String> getApiGroups(){
            return this.apiGroups;
    }

    public String getApiGroup(int index){
            return this.apiGroups.get(index);
    }

    public String getFirstApiGroup(){
            return this.apiGroups.get(0);
    }

    public String getLastApiGroup(){
            return this.apiGroups.get(apiGroups.size() - 1);
    }

    public String getMatchingApiGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: apiGroups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingApiGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: apiGroups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withApiGroups(List<String> apiGroups){
            if (this.apiGroups != null) { _visitables.get("apiGroups").removeAll(this.apiGroups);}
            if (apiGroups != null) {this.apiGroups = new ArrayList<String>(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
    }

    public A withApiGroups(String... apiGroups){
            if (this.apiGroups != null) {this.apiGroups.clear();}
            if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
    }

    public Boolean hasApiGroups(){
            return apiGroups != null && !apiGroups.isEmpty();
    }

    public A addNewApiGroup(String arg1){
            return (A)addToApiGroups(new String(arg1));
    }

    public A addNewApiGroup(StringBuilder arg1){
            return (A)addToApiGroups(new String(arg1));
    }

    public A addNewApiGroup(StringBuffer arg1){
            return (A)addToApiGroups(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildAttributeRestrictions instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getAttributeRestrictions(){
            return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
    }

    public HasMetadata buildAttributeRestrictions(){
            return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
    }

    public A withAttributeRestrictions(HasMetadata attributeRestrictions){
            if (attributeRestrictions instanceof ClusterVersion){ this.attributeRestrictions= new ClusterVersionBuilder((ClusterVersion)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof ImageStreamImport){ this.attributeRestrictions= new ImageStreamImportBuilder((ImageStreamImport)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof DeploymentConfig){ this.attributeRestrictions= new DeploymentConfigBuilder((DeploymentConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof OAuthAccessToken){ this.attributeRestrictions= new OAuthAccessTokenBuilder((OAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof RoleBinding){ this.attributeRestrictions= new RoleBindingBuilder((RoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Image){ this.attributeRestrictions= new ImageBuilder((Image)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof PersistentVolumeClaim){ this.attributeRestrictions= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Role){ this.attributeRestrictions= new RoleBuilder((Role)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Project){ this.attributeRestrictions= new ProjectBuilder((Project)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof BuildConfig){ this.attributeRestrictions= new BuildConfigBuilder((BuildConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof User){ this.attributeRestrictions= new UserBuilder((User)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Route){ this.attributeRestrictions= new RouteBuilder((Route)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Build){ this.attributeRestrictions= new BuildBuilder((Build)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof OAuthAuthorizeToken){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof RoleBindingRestriction){ this.attributeRestrictions= new RoleBindingRestrictionBuilder((RoleBindingRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof ImageStreamTag){ this.attributeRestrictions= new ImageStreamTagBuilder((ImageStreamTag)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Group){ this.attributeRestrictions= new GroupBuilder((Group)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof TokenReview){ this.attributeRestrictions= new TokenReviewBuilder((TokenReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof ImageSignature){ this.attributeRestrictions= new ImageSignatureBuilder((ImageSignature)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof SecurityContextConstraints){ this.attributeRestrictions= new SecurityContextConstraintsBuilder((SecurityContextConstraints)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof ClusterRoleBinding){ this.attributeRestrictions= new ClusterRoleBindingBuilder((ClusterRoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof BuildRequest){ this.attributeRestrictions= new BuildRequestBuilder((BuildRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof NetNamespace){ this.attributeRestrictions= new NetNamespaceBuilder((NetNamespace)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof ImageStream){ this.attributeRestrictions= new ImageStreamBuilder((ImageStream)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof ProjectRequest){ this.attributeRestrictions= new ProjectRequestBuilder((ProjectRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Template){ this.attributeRestrictions= new TemplateBuilder((Template)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof OAuthClientAuthorization){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof OAuthClient){ this.attributeRestrictions= new OAuthClientBuilder((OAuthClient)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof Identity){ this.attributeRestrictions= new IdentityBuilder((Identity)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            if (attributeRestrictions instanceof ClusterRole){ this.attributeRestrictions= new ClusterRoleBuilder((ClusterRole)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
            return (A) this;
    }

    public Boolean hasAttributeRestrictions(){
            return this.attributeRestrictions != null;
    }

    public A withClusterVersionAttributeRestrictions(ClusterVersion clusterVersionAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (clusterVersionAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterVersionBuilder(clusterVersionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictions(){
            return new ClusterVersionAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictionsLike(ClusterVersion item){
            return new ClusterVersionAttributeRestrictionsNestedImpl(item);
    }

    public A withImageStreamImportAttributeRestrictions(ImageStreamImport imageStreamImportAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (imageStreamImportAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportBuilder(imageStreamImportAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions(){
            return new ImageStreamImportAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(ImageStreamImport item){
            return new ImageStreamImportAttributeRestrictionsNestedImpl(item);
    }

    public A withDeploymentConfigAttributeRestrictions(DeploymentConfig deploymentConfigAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (deploymentConfigAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigBuilder(deploymentConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions(){
            return new DeploymentConfigAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(DeploymentConfig item){
            return new DeploymentConfigAttributeRestrictionsNestedImpl(item);
    }

    public A withOAuthAccessTokenAttributeRestrictions(OAuthAccessToken oAuthAccessTokenAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (oAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAccessTokenBuilder(oAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions(){
            return new OAuthAccessTokenAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(OAuthAccessToken item){
            return new OAuthAccessTokenAttributeRestrictionsNestedImpl(item);
    }

    public A withRoleBindingAttributeRestrictions(RoleBinding roleBindingAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (roleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingBuilder(roleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions(){
            return new RoleBindingAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(RoleBinding item){
            return new RoleBindingAttributeRestrictionsNestedImpl(item);
    }

    public A withImageAttributeRestrictions(Image imageAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (imageAttributeRestrictions!=null){ this.attributeRestrictions= new ImageBuilder(imageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions(){
            return new ImageAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(Image item){
            return new ImageAttributeRestrictionsNestedImpl(item);
    }

    public A withPersistentVolumeClaimAttributeRestrictions(PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (persistentVolumeClaimAttributeRestrictions!=null){ this.attributeRestrictions= new PersistentVolumeClaimBuilder(persistentVolumeClaimAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions(){
            return new PersistentVolumeClaimAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimAttributeRestrictionsNestedImpl(item);
    }

    public A withRoleAttributeRestrictions(Role roleAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (roleAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBuilder(roleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions(){
            return new RoleAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(Role item){
            return new RoleAttributeRestrictionsNestedImpl(item);
    }

    public A withProjectAttributeRestrictions(Project projectAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (projectAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectBuilder(projectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions(){
            return new ProjectAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(Project item){
            return new ProjectAttributeRestrictionsNestedImpl(item);
    }

    public A withBuildConfigAttributeRestrictions(BuildConfig buildConfigAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (buildConfigAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigBuilder(buildConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions(){
            return new BuildConfigAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(BuildConfig item){
            return new BuildConfigAttributeRestrictionsNestedImpl(item);
    }

    public A withUserAttributeRestrictions(User userAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (userAttributeRestrictions!=null){ this.attributeRestrictions= new UserBuilder(userAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions(){
            return new UserAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(User item){
            return new UserAttributeRestrictionsNestedImpl(item);
    }

    public A withRouteAttributeRestrictions(Route routeAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (routeAttributeRestrictions!=null){ this.attributeRestrictions= new RouteBuilder(routeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions(){
            return new RouteAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(Route item){
            return new RouteAttributeRestrictionsNestedImpl(item);
    }

    public A withBuildAttributeRestrictions(Build buildAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (buildAttributeRestrictions!=null){ this.attributeRestrictions= new BuildBuilder(buildAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions(){
            return new BuildAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(Build item){
            return new BuildAttributeRestrictionsNestedImpl(item);
    }

    public A withOAuthAuthorizeTokenAttributeRestrictions(OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (oAuthAuthorizeTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions(){
            return new OAuthAuthorizeTokenAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(item);
    }

    public A withRoleBindingRestrictionAttributeRestrictions(RoleBindingRestriction roleBindingRestrictionAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (roleBindingRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionBuilder(roleBindingRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions(){
            return new RoleBindingRestrictionAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(RoleBindingRestriction item){
            return new RoleBindingRestrictionAttributeRestrictionsNestedImpl(item);
    }

    public A withImageStreamTagAttributeRestrictions(ImageStreamTag imageStreamTagAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (imageStreamTagAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagBuilder(imageStreamTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions(){
            return new ImageStreamTagAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(ImageStreamTag item){
            return new ImageStreamTagAttributeRestrictionsNestedImpl(item);
    }

    public A withGroupAttributeRestrictions(Group groupAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (groupAttributeRestrictions!=null){ this.attributeRestrictions= new GroupBuilder(groupAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions(){
            return new GroupAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(Group item){
            return new GroupAttributeRestrictionsNestedImpl(item);
    }

    public A withTokenReviewAttributeRestrictions(TokenReview tokenReviewAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (tokenReviewAttributeRestrictions!=null){ this.attributeRestrictions= new TokenReviewBuilder(tokenReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.TokenReviewAttributeRestrictionsNested<A> withNewTokenReviewAttributeRestrictions(){
            return new TokenReviewAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.TokenReviewAttributeRestrictionsNested<A> withNewTokenReviewAttributeRestrictionsLike(TokenReview item){
            return new TokenReviewAttributeRestrictionsNestedImpl(item);
    }

    public A withImageSignatureAttributeRestrictions(ImageSignature imageSignatureAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (imageSignatureAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSignatureBuilder(imageSignatureAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions(){
            return new ImageSignatureAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(ImageSignature item){
            return new ImageSignatureAttributeRestrictionsNestedImpl(item);
    }

    public A withSecurityContextConstraintsAttributeRestrictions(SecurityContextConstraints securityContextConstraintsAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (securityContextConstraintsAttributeRestrictions!=null){ this.attributeRestrictions= new SecurityContextConstraintsBuilder(securityContextConstraintsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions(){
            return new SecurityContextConstraintsAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsAttributeRestrictionsNestedImpl(item);
    }

    public A withClusterRoleBindingAttributeRestrictions(ClusterRoleBinding clusterRoleBindingAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (clusterRoleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBindingBuilder(clusterRoleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions(){
            return new ClusterRoleBindingAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(ClusterRoleBinding item){
            return new ClusterRoleBindingAttributeRestrictionsNestedImpl(item);
    }

    public A withBuildRequestAttributeRestrictions(BuildRequest buildRequestAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (buildRequestAttributeRestrictions!=null){ this.attributeRestrictions= new BuildRequestBuilder(buildRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions(){
            return new BuildRequestAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(BuildRequest item){
            return new BuildRequestAttributeRestrictionsNestedImpl(item);
    }

    public A withNetNamespaceAttributeRestrictions(NetNamespace netNamespaceAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (netNamespaceAttributeRestrictions!=null){ this.attributeRestrictions= new NetNamespaceBuilder(netNamespaceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions(){
            return new NetNamespaceAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(NetNamespace item){
            return new NetNamespaceAttributeRestrictionsNestedImpl(item);
    }

    public A withImageStreamAttributeRestrictions(ImageStream imageStreamAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (imageStreamAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamBuilder(imageStreamAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions(){
            return new ImageStreamAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(ImageStream item){
            return new ImageStreamAttributeRestrictionsNestedImpl(item);
    }

    public A withProjectRequestAttributeRestrictions(ProjectRequest projectRequestAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (projectRequestAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectRequestBuilder(projectRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions(){
            return new ProjectRequestAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(ProjectRequest item){
            return new ProjectRequestAttributeRestrictionsNestedImpl(item);
    }

    public A withTemplateAttributeRestrictions(Template templateAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (templateAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateBuilder(templateAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions(){
            return new TemplateAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(Template item){
            return new TemplateAttributeRestrictionsNestedImpl(item);
    }

    public A withOAuthClientAuthorizationAttributeRestrictions(OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (oAuthClientAuthorizationAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions(){
            return new OAuthClientAuthorizationAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationAttributeRestrictionsNestedImpl(item);
    }

    public A withOAuthClientAttributeRestrictions(OAuthClient oAuthClientAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (oAuthClientAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientBuilder(oAuthClientAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions(){
            return new OAuthClientAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(OAuthClient item){
            return new OAuthClientAttributeRestrictionsNestedImpl(item);
    }

    public A withIdentityAttributeRestrictions(Identity identityAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (identityAttributeRestrictions!=null){ this.attributeRestrictions= new IdentityBuilder(identityAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions(){
            return new IdentityAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(Identity item){
            return new IdentityAttributeRestrictionsNestedImpl(item);
    }

    public A withClusterRoleAttributeRestrictions(ClusterRole clusterRoleAttributeRestrictions){
            _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
            if (clusterRoleAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBuilder(clusterRoleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
    }

    public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions(){
            return new ClusterRoleAttributeRestrictionsNestedImpl();
    }

    public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(ClusterRole item){
            return new ClusterRoleAttributeRestrictionsNestedImpl(item);
    }

    public A addToNonResourceURLs(int index,String item){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            this.nonResourceURLs.add(index, item);
            return (A)this;
    }

    public A setToNonResourceURLs(int index,String item){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            this.nonResourceURLs.set(index, item); return (A)this;
    }

    public A addToNonResourceURLs(String... items){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
    }

    public A addAllToNonResourceURLs(Collection<String> items){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
    }

    public A removeFromNonResourceURLs(String... items){
            for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
    }

    public A removeAllFromNonResourceURLs(Collection<String> items){
            for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
    }

    public List<String> getNonResourceURLs(){
            return this.nonResourceURLs;
    }

    public String getNonResourceURL(int index){
            return this.nonResourceURLs.get(index);
    }

    public String getFirstNonResourceURL(){
            return this.nonResourceURLs.get(0);
    }

    public String getLastNonResourceURL(){
            return this.nonResourceURLs.get(nonResourceURLs.size() - 1);
    }

    public String getMatchingNonResourceURL(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: nonResourceURLs) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNonResourceURL(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: nonResourceURLs) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNonResourceURLs(List<String> nonResourceURLs){
            if (this.nonResourceURLs != null) { _visitables.get("nonResourceURLs").removeAll(this.nonResourceURLs);}
            if (nonResourceURLs != null) {this.nonResourceURLs = new ArrayList<String>(); for (String item : nonResourceURLs){this.addToNonResourceURLs(item);}} else { this.nonResourceURLs = null;} return (A) this;
    }

    public A withNonResourceURLs(String... nonResourceURLs){
            if (this.nonResourceURLs != null) {this.nonResourceURLs.clear();}
            if (nonResourceURLs != null) {for (String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (A) this;
    }

    public Boolean hasNonResourceURLs(){
            return nonResourceURLs != null && !nonResourceURLs.isEmpty();
    }

    public A addNewNonResourceURL(String arg1){
            return (A)addToNonResourceURLs(new String(arg1));
    }

    public A addNewNonResourceURL(StringBuilder arg1){
            return (A)addToNonResourceURLs(new String(arg1));
    }

    public A addNewNonResourceURL(StringBuffer arg1){
            return (A)addToNonResourceURLs(new String(arg1));
    }

    public A addToResourceNames(int index,String item){
            if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
            this.resourceNames.add(index, item);
            return (A)this;
    }

    public A setToResourceNames(int index,String item){
            if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
            this.resourceNames.set(index, item); return (A)this;
    }

    public A addToResourceNames(String... items){
            if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
            for (String item : items) {this.resourceNames.add(item);} return (A)this;
    }

    public A addAllToResourceNames(Collection<String> items){
            if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
            for (String item : items) {this.resourceNames.add(item);} return (A)this;
    }

    public A removeFromResourceNames(String... items){
            for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
    }

    public A removeAllFromResourceNames(Collection<String> items){
            for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
    }

    public List<String> getResourceNames(){
            return this.resourceNames;
    }

    public String getResourceName(int index){
            return this.resourceNames.get(index);
    }

    public String getFirstResourceName(){
            return this.resourceNames.get(0);
    }

    public String getLastResourceName(){
            return this.resourceNames.get(resourceNames.size() - 1);
    }

    public String getMatchingResourceName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: resourceNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingResourceName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: resourceNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResourceNames(List<String> resourceNames){
            if (this.resourceNames != null) { _visitables.get("resourceNames").removeAll(this.resourceNames);}
            if (resourceNames != null) {this.resourceNames = new ArrayList<String>(); for (String item : resourceNames){this.addToResourceNames(item);}} else { this.resourceNames = null;} return (A) this;
    }

    public A withResourceNames(String... resourceNames){
            if (this.resourceNames != null) {this.resourceNames.clear();}
            if (resourceNames != null) {for (String item :resourceNames){ this.addToResourceNames(item);}} return (A) this;
    }

    public Boolean hasResourceNames(){
            return resourceNames != null && !resourceNames.isEmpty();
    }

    public A addNewResourceName(String arg1){
            return (A)addToResourceNames(new String(arg1));
    }

    public A addNewResourceName(StringBuilder arg1){
            return (A)addToResourceNames(new String(arg1));
    }

    public A addNewResourceName(StringBuffer arg1){
            return (A)addToResourceNames(new String(arg1));
    }

    public A addToResources(int index,String item){
            if (this.resources == null) {this.resources = new ArrayList<String>();}
            this.resources.add(index, item);
            return (A)this;
    }

    public A setToResources(int index,String item){
            if (this.resources == null) {this.resources = new ArrayList<String>();}
            this.resources.set(index, item); return (A)this;
    }

    public A addToResources(String... items){
            if (this.resources == null) {this.resources = new ArrayList<String>();}
            for (String item : items) {this.resources.add(item);} return (A)this;
    }

    public A addAllToResources(Collection<String> items){
            if (this.resources == null) {this.resources = new ArrayList<String>();}
            for (String item : items) {this.resources.add(item);} return (A)this;
    }

    public A removeFromResources(String... items){
            for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
    }

    public A removeAllFromResources(Collection<String> items){
            for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
    }

    public List<String> getResources(){
            return this.resources;
    }

    public String getResource(int index){
            return this.resources.get(index);
    }

    public String getFirstResource(){
            return this.resources.get(0);
    }

    public String getLastResource(){
            return this.resources.get(resources.size() - 1);
    }

    public String getMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: resources) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: resources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResources(List<String> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<String>(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(String... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public A addNewResource(String arg1){
            return (A)addToResources(new String(arg1));
    }

    public A addNewResource(StringBuilder arg1){
            return (A)addToResources(new String(arg1));
    }

    public A addNewResource(StringBuffer arg1){
            return (A)addToResources(new String(arg1));
    }

    public A addToVerbs(int index,String item){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            this.verbs.add(index, item);
            return (A)this;
    }

    public A setToVerbs(int index,String item){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            this.verbs.set(index, item); return (A)this;
    }

    public A addToVerbs(String... items){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            for (String item : items) {this.verbs.add(item);} return (A)this;
    }

    public A addAllToVerbs(Collection<String> items){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            for (String item : items) {this.verbs.add(item);} return (A)this;
    }

    public A removeFromVerbs(String... items){
            for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
    }

    public A removeAllFromVerbs(Collection<String> items){
            for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
    }

    public List<String> getVerbs(){
            return this.verbs;
    }

    public String getVerb(int index){
            return this.verbs.get(index);
    }

    public String getFirstVerb(){
            return this.verbs.get(0);
    }

    public String getLastVerb(){
            return this.verbs.get(verbs.size() - 1);
    }

    public String getMatchingVerb(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: verbs) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVerb(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: verbs) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVerbs(List<String> verbs){
            if (this.verbs != null) { _visitables.get("verbs").removeAll(this.verbs);}
            if (verbs != null) {this.verbs = new ArrayList<String>(); for (String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
    }

    public A withVerbs(String... verbs){
            if (this.verbs != null) {this.verbs.clear();}
            if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
    }

    public Boolean hasVerbs(){
            return verbs != null && !verbs.isEmpty();
    }

    public A addNewVerb(String arg1){
            return (A)addToVerbs(new String(arg1));
    }

    public A addNewVerb(StringBuilder arg1){
            return (A)addToVerbs(new String(arg1));
    }

    public A addNewVerb(StringBuffer arg1){
            return (A)addToVerbs(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PolicyRuleFluentImpl that = (PolicyRuleFluentImpl) o;
            if (apiGroups != null ? !apiGroups.equals(that.apiGroups) :that.apiGroups != null) return false;
            if (attributeRestrictions != null ? !attributeRestrictions.equals(that.attributeRestrictions) :that.attributeRestrictions != null) return false;
            if (nonResourceURLs != null ? !nonResourceURLs.equals(that.nonResourceURLs) :that.nonResourceURLs != null) return false;
            if (resourceNames != null ? !resourceNames.equals(that.resourceNames) :that.resourceNames != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
            return true;
    }


    public class ClusterVersionAttributeRestrictionsNestedImpl<N> extends ClusterVersionFluentImpl<PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterVersionBuilder builder;
    
            ClusterVersionAttributeRestrictionsNestedImpl(ClusterVersion item){
                    this.builder = new ClusterVersionBuilder(this, item);
            }
            ClusterVersionAttributeRestrictionsNestedImpl(){
                    this.builder = new ClusterVersionBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterVersionAttributeRestrictions(){
            return and();
    }

}
    public class ImageStreamImportAttributeRestrictionsNestedImpl<N> extends ImageStreamImportFluentImpl<PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamImportBuilder builder;
    
            ImageStreamImportAttributeRestrictionsNestedImpl(ImageStreamImport item){
                    this.builder = new ImageStreamImportBuilder(this, item);
            }
            ImageStreamImportAttributeRestrictionsNestedImpl(){
                    this.builder = new ImageStreamImportBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportAttributeRestrictions(){
            return and();
    }

}
    public class DeploymentConfigAttributeRestrictionsNestedImpl<N> extends DeploymentConfigFluentImpl<PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentConfigBuilder builder;
    
            DeploymentConfigAttributeRestrictionsNestedImpl(DeploymentConfig item){
                    this.builder = new DeploymentConfigBuilder(this, item);
            }
            DeploymentConfigAttributeRestrictionsNestedImpl(){
                    this.builder = new DeploymentConfigBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigAttributeRestrictions(){
            return and();
    }

}
    public class OAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends OAuthAccessTokenFluentImpl<PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAccessTokenBuilder builder;
    
            OAuthAccessTokenAttributeRestrictionsNestedImpl(OAuthAccessToken item){
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
            OAuthAccessTokenAttributeRestrictionsNestedImpl(){
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAccessTokenAttributeRestrictions(){
            return and();
    }

}
    public class RoleBindingAttributeRestrictionsNestedImpl<N> extends RoleBindingFluentImpl<PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingAttributeRestrictionsNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
            RoleBindingAttributeRestrictionsNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingAttributeRestrictions(){
            return and();
    }

}
    public class ImageAttributeRestrictionsNestedImpl<N> extends ImageFluentImpl<PolicyRuleFluent.ImageAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageBuilder builder;
    
            ImageAttributeRestrictionsNestedImpl(Image item){
                    this.builder = new ImageBuilder(this, item);
            }
            ImageAttributeRestrictionsNestedImpl(){
                    this.builder = new ImageBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageAttributeRestrictions(){
            return and();
    }

}
    public class PersistentVolumeClaimAttributeRestrictionsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
    
            PersistentVolumeClaimAttributeRestrictionsNestedImpl(PersistentVolumeClaim item){
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
            PersistentVolumeClaimAttributeRestrictionsNestedImpl(){
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPersistentVolumeClaimAttributeRestrictions(){
            return and();
    }

}
    public class RoleAttributeRestrictionsNestedImpl<N> extends RoleFluentImpl<PolicyRuleFluent.RoleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBuilder builder;
    
            RoleAttributeRestrictionsNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
            RoleAttributeRestrictionsNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleAttributeRestrictions(){
            return and();
    }

}
    public class ProjectAttributeRestrictionsNestedImpl<N> extends ProjectFluentImpl<PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectBuilder builder;
    
            ProjectAttributeRestrictionsNestedImpl(Project item){
                    this.builder = new ProjectBuilder(this, item);
            }
            ProjectAttributeRestrictionsNestedImpl(){
                    this.builder = new ProjectBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectAttributeRestrictions(){
            return and();
    }

}
    public class BuildConfigAttributeRestrictionsNestedImpl<N> extends BuildConfigFluentImpl<PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildConfigBuilder builder;
    
            BuildConfigAttributeRestrictionsNestedImpl(BuildConfig item){
                    this.builder = new BuildConfigBuilder(this, item);
            }
            BuildConfigAttributeRestrictionsNestedImpl(){
                    this.builder = new BuildConfigBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigAttributeRestrictions(){
            return and();
    }

}
    public class UserAttributeRestrictionsNestedImpl<N> extends UserFluentImpl<PolicyRuleFluent.UserAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UserBuilder builder;
    
            UserAttributeRestrictionsNestedImpl(User item){
                    this.builder = new UserBuilder(this, item);
            }
            UserAttributeRestrictionsNestedImpl(){
                    this.builder = new UserBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserAttributeRestrictions(){
            return and();
    }

}
    public class RouteAttributeRestrictionsNestedImpl<N> extends RouteFluentImpl<PolicyRuleFluent.RouteAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteBuilder builder;
    
            RouteAttributeRestrictionsNestedImpl(Route item){
                    this.builder = new RouteBuilder(this, item);
            }
            RouteAttributeRestrictionsNestedImpl(){
                    this.builder = new RouteBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteAttributeRestrictions(){
            return and();
    }

}
    public class BuildAttributeRestrictionsNestedImpl<N> extends BuildFluentImpl<PolicyRuleFluent.BuildAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildBuilder builder;
    
            BuildAttributeRestrictionsNestedImpl(Build item){
                    this.builder = new BuildBuilder(this, item);
            }
            BuildAttributeRestrictionsNestedImpl(){
                    this.builder = new BuildBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildAttributeRestrictions(){
            return and();
    }

}
    public class OAuthAuthorizeTokenAttributeRestrictionsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
    
            OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(OAuthAuthorizeToken item){
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
            OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(){
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAuthorizeTokenAttributeRestrictions(){
            return and();
    }

}
    public class RoleBindingRestrictionAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingRestrictionBuilder builder;
    
            RoleBindingRestrictionAttributeRestrictionsNestedImpl(RoleBindingRestriction item){
                    this.builder = new RoleBindingRestrictionBuilder(this, item);
            }
            RoleBindingRestrictionAttributeRestrictionsNestedImpl(){
                    this.builder = new RoleBindingRestrictionBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionAttributeRestrictions(){
            return and();
    }

}
    public class ImageStreamTagAttributeRestrictionsNestedImpl<N> extends ImageStreamTagFluentImpl<PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamTagBuilder builder;
    
            ImageStreamTagAttributeRestrictionsNestedImpl(ImageStreamTag item){
                    this.builder = new ImageStreamTagBuilder(this, item);
            }
            ImageStreamTagAttributeRestrictionsNestedImpl(){
                    this.builder = new ImageStreamTagBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagAttributeRestrictions(){
            return and();
    }

}
    public class GroupAttributeRestrictionsNestedImpl<N> extends GroupFluentImpl<PolicyRuleFluent.GroupAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GroupAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GroupBuilder builder;
    
            GroupAttributeRestrictionsNestedImpl(Group item){
                    this.builder = new GroupBuilder(this, item);
            }
            GroupAttributeRestrictionsNestedImpl(){
                    this.builder = new GroupBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupAttributeRestrictions(){
            return and();
    }

}
    public class TokenReviewAttributeRestrictionsNestedImpl<N> extends TokenReviewFluentImpl<PolicyRuleFluent.TokenReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TokenReviewAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TokenReviewBuilder builder;
    
            TokenReviewAttributeRestrictionsNestedImpl(TokenReview item){
                    this.builder = new TokenReviewBuilder(this, item);
            }
            TokenReviewAttributeRestrictionsNestedImpl(){
                    this.builder = new TokenReviewBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTokenReviewAttributeRestrictions(){
            return and();
    }

}
    public class ImageSignatureAttributeRestrictionsNestedImpl<N> extends ImageSignatureFluentImpl<PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSignatureBuilder builder;
    
            ImageSignatureAttributeRestrictionsNestedImpl(ImageSignature item){
                    this.builder = new ImageSignatureBuilder(this, item);
            }
            ImageSignatureAttributeRestrictionsNestedImpl(){
                    this.builder = new ImageSignatureBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSignatureAttributeRestrictions(){
            return and();
    }

}
    public class SecurityContextConstraintsAttributeRestrictionsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
    
            SecurityContextConstraintsAttributeRestrictionsNestedImpl(SecurityContextConstraints item){
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
            SecurityContextConstraintsAttributeRestrictionsNestedImpl(){
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecurityContextConstraintsAttributeRestrictions(){
            return and();
    }

}
    public class ClusterRoleBindingAttributeRestrictionsNestedImpl<N> extends ClusterRoleBindingFluentImpl<PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBindingBuilder builder;
    
            ClusterRoleBindingAttributeRestrictionsNestedImpl(ClusterRoleBinding item){
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
            ClusterRoleBindingAttributeRestrictionsNestedImpl(){
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleBindingAttributeRestrictions(){
            return and();
    }

}
    public class BuildRequestAttributeRestrictionsNestedImpl<N> extends BuildRequestFluentImpl<PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildRequestBuilder builder;
    
            BuildRequestAttributeRestrictionsNestedImpl(BuildRequest item){
                    this.builder = new BuildRequestBuilder(this, item);
            }
            BuildRequestAttributeRestrictionsNestedImpl(){
                    this.builder = new BuildRequestBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildRequestAttributeRestrictions(){
            return and();
    }

}
    public class NetNamespaceAttributeRestrictionsNestedImpl<N> extends NetNamespaceFluentImpl<PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NetNamespaceBuilder builder;
    
            NetNamespaceAttributeRestrictionsNestedImpl(NetNamespace item){
                    this.builder = new NetNamespaceBuilder(this, item);
            }
            NetNamespaceAttributeRestrictionsNestedImpl(){
                    this.builder = new NetNamespaceBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetNamespaceAttributeRestrictions(){
            return and();
    }

}
    public class ImageStreamAttributeRestrictionsNestedImpl<N> extends ImageStreamFluentImpl<PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamBuilder builder;
    
            ImageStreamAttributeRestrictionsNestedImpl(ImageStream item){
                    this.builder = new ImageStreamBuilder(this, item);
            }
            ImageStreamAttributeRestrictionsNestedImpl(){
                    this.builder = new ImageStreamBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamAttributeRestrictions(){
            return and();
    }

}
    public class ProjectRequestAttributeRestrictionsNestedImpl<N> extends ProjectRequestFluentImpl<PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectRequestBuilder builder;
    
            ProjectRequestAttributeRestrictionsNestedImpl(ProjectRequest item){
                    this.builder = new ProjectRequestBuilder(this, item);
            }
            ProjectRequestAttributeRestrictionsNestedImpl(){
                    this.builder = new ProjectRequestBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectRequestAttributeRestrictions(){
            return and();
    }

}
    public class TemplateAttributeRestrictionsNestedImpl<N> extends TemplateFluentImpl<PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TemplateBuilder builder;
    
            TemplateAttributeRestrictionsNestedImpl(Template item){
                    this.builder = new TemplateBuilder(this, item);
            }
            TemplateAttributeRestrictionsNestedImpl(){
                    this.builder = new TemplateBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateAttributeRestrictions(){
            return and();
    }

}
    public class OAuthClientAuthorizationAttributeRestrictionsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
    
            OAuthClientAuthorizationAttributeRestrictionsNestedImpl(OAuthClientAuthorization item){
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
            OAuthClientAuthorizationAttributeRestrictionsNestedImpl(){
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAuthorizationAttributeRestrictions(){
            return and();
    }

}
    public class OAuthClientAttributeRestrictionsNestedImpl<N> extends OAuthClientFluentImpl<PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientBuilder builder;
    
            OAuthClientAttributeRestrictionsNestedImpl(OAuthClient item){
                    this.builder = new OAuthClientBuilder(this, item);
            }
            OAuthClientAttributeRestrictionsNestedImpl(){
                    this.builder = new OAuthClientBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAttributeRestrictions(){
            return and();
    }

}
    public class IdentityAttributeRestrictionsNestedImpl<N> extends IdentityFluentImpl<PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>> implements PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IdentityBuilder builder;
    
            IdentityAttributeRestrictionsNestedImpl(Identity item){
                    this.builder = new IdentityBuilder(this, item);
            }
            IdentityAttributeRestrictionsNestedImpl(){
                    this.builder = new IdentityBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIdentityAttributeRestrictions(){
            return and();
    }

}
    public class ClusterRoleAttributeRestrictionsNestedImpl<N> extends ClusterRoleFluentImpl<PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBuilder builder;
    
            ClusterRoleAttributeRestrictionsNestedImpl(ClusterRole item){
                    this.builder = new ClusterRoleBuilder(this, item);
            }
            ClusterRoleAttributeRestrictionsNestedImpl(){
                    this.builder = new ClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleAttributeRestrictions(){
            return and();
    }

}


}
