package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface NetNamespaceListFluent<A extends NetNamespaceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,NetNamespace item);
    public A setToItems(int index,NetNamespace item);
    public A addToItems(NetNamespace... items);
    public A addAllToItems(Collection<NetNamespace> items);
    public A removeFromItems(NetNamespace... items);
    public A removeAllFromItems(Collection<NetNamespace> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<NetNamespaceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<NetNamespace> getItems();
    public List<NetNamespace> buildItems();
    public NetNamespace buildItem(int index);
    public NetNamespace buildFirstItem();
    public NetNamespace buildLastItem();
    public NetNamespace buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<NetNamespaceBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<NetNamespaceBuilder> predicate);
    public A withItems(List<NetNamespace> items);
    public A withItems(NetNamespace... items);
    public Boolean hasItems();
    public NetNamespaceListFluent.ItemsNested<A> addNewItem();
    public NetNamespaceListFluent.ItemsNested<A> addNewItemLike(NetNamespace item);
    public NetNamespaceListFluent.ItemsNested<A> setNewItemLike(int index,NetNamespace item);
    public NetNamespaceListFluent.ItemsNested<A> editItem(int index);
    public NetNamespaceListFluent.ItemsNested<A> editFirstItem();
    public NetNamespaceListFluent.ItemsNested<A> editLastItem();
    public NetNamespaceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<NetNamespaceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<NetNamespaceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
