package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SubjectAccessReviewFluent<A extends SubjectAccessReviewFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildContent instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getContent();
    public HasMetadata buildContent();
    public A withContent(HasMetadata content);
    public Boolean hasContent();
    public A withClusterVersionContent(ClusterVersion clusterVersionContent);
    public SubjectAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContent();
    public SubjectAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContentLike(ClusterVersion item);
    public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent);
    public SubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent();
    public SubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item);
    public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent);
    public SubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent();
    public SubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item);
    public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent);
    public SubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent();
    public SubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item);
    public A withRoleBindingContent(RoleBinding roleBindingContent);
    public SubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent();
    public SubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item);
    public A withImageContent(Image imageContent);
    public SubjectAccessReviewFluent.ImageContentNested<A> withNewImageContent();
    public SubjectAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item);
    public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent);
    public SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent();
    public SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item);
    public A withRoleContent(Role roleContent);
    public SubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContent();
    public SubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item);
    public A withProjectContent(Project projectContent);
    public SubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContent();
    public SubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item);
    public A withBuildConfigContent(BuildConfig buildConfigContent);
    public SubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent();
    public SubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item);
    public A withUserContent(User userContent);
    public SubjectAccessReviewFluent.UserContentNested<A> withNewUserContent();
    public SubjectAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item);
    public A withRouteContent(Route routeContent);
    public SubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContent();
    public SubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item);
    public A withBuildContent(Build buildContent);
    public SubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContent();
    public SubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item);
    public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent);
    public SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent();
    public SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item);
    public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent);
    public SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent();
    public SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item);
    public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent);
    public SubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent();
    public SubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item);
    public A withGroupContent(Group groupContent);
    public SubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContent();
    public SubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(Group item);
    public A withTokenReviewContent(TokenReview tokenReviewContent);
    public SubjectAccessReviewFluent.TokenReviewContentNested<A> withNewTokenReviewContent();
    public SubjectAccessReviewFluent.TokenReviewContentNested<A> withNewTokenReviewContentLike(TokenReview item);
    public A withImageSignatureContent(ImageSignature imageSignatureContent);
    public SubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent();
    public SubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item);
    public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent);
    public SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent();
    public SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item);
    public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent);
    public SubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent();
    public SubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item);
    public A withBuildRequestContent(BuildRequest buildRequestContent);
    public SubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent();
    public SubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item);
    public A withNetNamespaceContent(NetNamespace netNamespaceContent);
    public SubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent();
    public SubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item);
    public A withImageStreamContent(ImageStream imageStreamContent);
    public SubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent();
    public SubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item);
    public A withProjectRequestContent(ProjectRequest projectRequestContent);
    public SubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent();
    public SubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item);
    public A withTemplateContent(Template templateContent);
    public SubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent();
    public SubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item);
    public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent);
    public SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent();
    public SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item);
    public A withOAuthClientContent(OAuthClient oAuthClientContent);
    public SubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent();
    public SubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item);
    public A withIdentityContent(Identity identityContent);
    public SubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent();
    public SubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item);
    public A withClusterRoleContent(ClusterRole clusterRoleContent);
    public SubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent();
    public SubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item);
    public A addToGroups(int index,String item);
    public A setToGroups(int index,String item);
    public A addToGroups(String... items);
    public A addAllToGroups(Collection<String> items);
    public A removeFromGroups(String... items);
    public A removeAllFromGroups(Collection<String> items);
    public List<String> getGroups();
    public String getGroup(int index);
    public String getFirstGroup();
    public String getLastGroup();
    public String getMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public Boolean hasGroups();
    public A addNewGroup(String arg1);
    public A addNewGroup(StringBuilder arg1);
    public A addNewGroup(StringBuffer arg1);
    public Boolean isIsNonResourceURL();
    public A withIsNonResourceURL(Boolean isNonResourceURL);
    public Boolean hasIsNonResourceURL();
    public A withNewIsNonResourceURL(String arg1);
    public A withNewIsNonResourceURL(boolean arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);
    public String getPath();
    public A withPath(String path);
    public Boolean hasPath();
    public A withNewPath(String arg1);
    public A withNewPath(StringBuilder arg1);
    public A withNewPath(StringBuffer arg1);
    public String getResource();
    public A withResource(String resource);
    public Boolean hasResource();
    public A withNewResource(String arg1);
    public A withNewResource(StringBuilder arg1);
    public A withNewResource(StringBuffer arg1);
    public String getResourceAPIGroup();
    public A withResourceAPIGroup(String resourceAPIGroup);
    public Boolean hasResourceAPIGroup();
    public A withNewResourceAPIGroup(String arg1);
    public A withNewResourceAPIGroup(StringBuilder arg1);
    public A withNewResourceAPIGroup(StringBuffer arg1);
    public String getResourceAPIVersion();
    public A withResourceAPIVersion(String resourceAPIVersion);
    public Boolean hasResourceAPIVersion();
    public A withNewResourceAPIVersion(String arg1);
    public A withNewResourceAPIVersion(StringBuilder arg1);
    public A withNewResourceAPIVersion(StringBuffer arg1);
    public String getResourceName();
    public A withResourceName(String resourceName);
    public Boolean hasResourceName();
    public A withNewResourceName(String arg1);
    public A withNewResourceName(StringBuilder arg1);
    public A withNewResourceName(StringBuffer arg1);
    public A addToScopes(int index,String item);
    public A setToScopes(int index,String item);
    public A addToScopes(String... items);
    public A addAllToScopes(Collection<String> items);
    public A removeFromScopes(String... items);
    public A removeAllFromScopes(Collection<String> items);
    public List<String> getScopes();
    public String getScope(int index);
    public String getFirstScope();
    public String getLastScope();
    public String getMatchingScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);
    public Boolean hasScopes();
    public A addNewScope(String arg1);
    public A addNewScope(StringBuilder arg1);
    public A addNewScope(StringBuffer arg1);
    public String getUser();
    public A withUser(String user);
    public Boolean hasUser();
    public A withNewUser(String arg1);
    public A withNewUser(StringBuilder arg1);
    public A withNewUser(StringBuffer arg1);
    public String getVerb();
    public A withVerb(String verb);
    public Boolean hasVerb();
    public A withNewVerb(String arg1);
    public A withNewVerb(StringBuilder arg1);
    public A withNewVerb(StringBuffer arg1);

    public interface ClusterVersionContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<SubjectAccessReviewFluent.ClusterVersionContentNested<N>>{

        
    public N and();    public N endClusterVersionContent();
}
    public interface ImageStreamImportContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImportFluent<SubjectAccessReviewFluent.ImageStreamImportContentNested<N>>{

        
    public N and();    public N endImageStreamImportContent();
}
    public interface DeploymentConfigContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<SubjectAccessReviewFluent.DeploymentConfigContentNested<N>>{

        
    public N and();    public N endDeploymentConfigContent();
}
    public interface OAuthAccessTokenContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<SubjectAccessReviewFluent.OAuthAccessTokenContentNested<N>>{

        
    public N and();    public N endOAuthAccessTokenContent();
}
    public interface RoleBindingContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<SubjectAccessReviewFluent.RoleBindingContentNested<N>>{

        
    public N and();    public N endRoleBindingContent();
}
    public interface ImageContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<SubjectAccessReviewFluent.ImageContentNested<N>>{

        
    public N and();    public N endImageContent();
}
    public interface PersistentVolumeClaimContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<N>>{

        
    public N and();    public N endPersistentVolumeClaimContent();
}
    public interface RoleContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<SubjectAccessReviewFluent.RoleContentNested<N>>{

        
    public N and();    public N endRoleContent();
}
    public interface ProjectContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<SubjectAccessReviewFluent.ProjectContentNested<N>>{

        
    public N and();    public N endProjectContent();
}
    public interface BuildConfigContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<SubjectAccessReviewFluent.BuildConfigContentNested<N>>{

        
    public N and();    public N endBuildConfigContent();
}
    public interface UserContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<SubjectAccessReviewFluent.UserContentNested<N>>{

        
    public N and();    public N endUserContent();
}
    public interface RouteContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<SubjectAccessReviewFluent.RouteContentNested<N>>{

        
    public N and();    public N endRouteContent();
}
    public interface BuildContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<SubjectAccessReviewFluent.BuildContentNested<N>>{

        
    public N and();    public N endBuildContent();
}
    public interface OAuthAuthorizeTokenContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>>{

        
    public N and();    public N endOAuthAuthorizeTokenContent();
}
    public interface RoleBindingRestrictionContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<N>>{

        
    public N and();    public N endRoleBindingRestrictionContent();
}
    public interface ImageStreamTagContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<SubjectAccessReviewFluent.ImageStreamTagContentNested<N>>{

        
    public N and();    public N endImageStreamTagContent();
}
    public interface GroupContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<SubjectAccessReviewFluent.GroupContentNested<N>>{

        
    public N and();    public N endGroupContent();
}
    public interface TokenReviewContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TokenReviewFluent<SubjectAccessReviewFluent.TokenReviewContentNested<N>>{

        
    public N and();    public N endTokenReviewContent();
}
    public interface ImageSignatureContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<SubjectAccessReviewFluent.ImageSignatureContentNested<N>>{

        
    public N and();    public N endImageSignatureContent();
}
    public interface SecurityContextConstraintsContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<N>>{

        
    public N and();    public N endSecurityContextConstraintsContent();
}
    public interface ClusterRoleBindingContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<SubjectAccessReviewFluent.ClusterRoleBindingContentNested<N>>{

        
    public N and();    public N endClusterRoleBindingContent();
}
    public interface BuildRequestContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<SubjectAccessReviewFluent.BuildRequestContentNested<N>>{

        
    public N and();    public N endBuildRequestContent();
}
    public interface NetNamespaceContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<SubjectAccessReviewFluent.NetNamespaceContentNested<N>>{

        
    public N and();    public N endNetNamespaceContent();
}
    public interface ImageStreamContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<SubjectAccessReviewFluent.ImageStreamContentNested<N>>{

        
    public N and();    public N endImageStreamContent();
}
    public interface ProjectRequestContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<SubjectAccessReviewFluent.ProjectRequestContentNested<N>>{

        
    public N and();    public N endProjectRequestContent();
}
    public interface TemplateContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<SubjectAccessReviewFluent.TemplateContentNested<N>>{

        
    public N and();    public N endTemplateContent();
}
    public interface OAuthClientAuthorizationContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<N>>{

        
    public N and();    public N endOAuthClientAuthorizationContent();
}
    public interface OAuthClientContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<SubjectAccessReviewFluent.OAuthClientContentNested<N>>{

        
    public N and();    public N endOAuthClientContent();
}
    public interface IdentityContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<SubjectAccessReviewFluent.IdentityContentNested<N>>{

        
    public N and();    public N endIdentityContent();
}
    public interface ClusterRoleContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<SubjectAccessReviewFluent.ClusterRoleContentNested<N>>{

        
    public N and();    public N endClusterRoleContent();
}


}
