package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

public class TemplateFluentImpl<A extends TemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TemplateFluent<A>{

    private String apiVersion;
    private String kind;
    private Map<String,String> labels;
    private ObjectMetaBuilder metadata;
    private List<VisitableBuilder<? extends HasMetadata,?>> objects;
    private List<ParameterBuilder> parameters;

    public TemplateFluentImpl(){
    }
    public TemplateFluentImpl(Template instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLabels(instance.getLabels()); 
            this.withMetadata(instance.getMetadata()); 
            this.withObjects(instance.getObjects()); 
            this.withParameters(instance.getParameters()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public A addToLabels(String key,String value){
            if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(this.labels == null) { return (A) this; }
            if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(this.labels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.labels != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public TemplateFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public TemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public TemplateFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public TemplateFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public TemplateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToObjects(VisitableBuilder<? extends HasMetadata,?> builder){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            _visitables.get("objects").add(builder);this.objects.add(builder); return (A)this;
    }

    public A addToObjects(int index,VisitableBuilder<? extends HasMetadata,?> builder){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            _visitables.get("objects").add(index, builder);this.objects.add(index, builder); return (A)this;
    }

    public A addToObjects(int index,HasMetadata item){
            if (item instanceof ClusterVersion){addToClusterVersionObjects(index, (ClusterVersion)item);}
 else if (item instanceof ImageStreamImport){addToImageStreamImportObjects(index, (ImageStreamImport)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects(index, (DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects(index, (OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects(index, (RoleBinding)item);}
 else if (item instanceof Image){addToImageObjects(index, (Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects(index, (PersistentVolumeClaim)item);}
 else if (item instanceof Role){addToRoleObjects(index, (Role)item);}
 else if (item instanceof Project){addToProjectObjects(index, (Project)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects(index, (BuildConfig)item);}
 else if (item instanceof User){addToUserObjects(index, (User)item);}
 else if (item instanceof Route){addToRouteObjects(index, (Route)item);}
 else if (item instanceof Build){addToBuildObjects(index, (Build)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects(index, (OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionObjects(index, (RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagObjects(index, (ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupObjects(index, (Group)item);}
 else if (item instanceof TokenReview){addToTokenReviewObjects(index, (TokenReview)item);}
 else if (item instanceof ImageSignature){addToImageSignatureObjects(index, (ImageSignature)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects(index, (SecurityContextConstraints)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects(index, (ClusterRoleBinding)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects(index, (BuildRequest)item);}
 else if (item instanceof NetNamespace){addToNetNamespaceObjects(index, (NetNamespace)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects(index, (ImageStream)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestObjects(index, (ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateObjects(index, (Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects(index, (OAuthClientAuthorization)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects(index, (OAuthClient)item);}
 else if (item instanceof Identity){addToIdentityObjects(index, (Identity)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects(index, (ClusterRole)item);}

            return (A)this;
    }

    public A setToObjects(int index,HasMetadata item){
            if (item instanceof ClusterVersion){setToClusterVersionObjects(index, (ClusterVersion)item);}
 else if (item instanceof ImageStreamImport){setToImageStreamImportObjects(index, (ImageStreamImport)item);}
 else if (item instanceof DeploymentConfig){setToDeploymentConfigObjects(index, (DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){setToOAuthAccessTokenObjects(index, (OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){setToRoleBindingObjects(index, (RoleBinding)item);}
 else if (item instanceof Image){setToImageObjects(index, (Image)item);}
 else if (item instanceof PersistentVolumeClaim){setToPersistentVolumeClaimObjects(index, (PersistentVolumeClaim)item);}
 else if (item instanceof Role){setToRoleObjects(index, (Role)item);}
 else if (item instanceof Project){setToProjectObjects(index, (Project)item);}
 else if (item instanceof BuildConfig){setToBuildConfigObjects(index, (BuildConfig)item);}
 else if (item instanceof User){setToUserObjects(index, (User)item);}
 else if (item instanceof Route){setToRouteObjects(index, (Route)item);}
 else if (item instanceof Build){setToBuildObjects(index, (Build)item);}
 else if (item instanceof OAuthAuthorizeToken){setToOAuthAuthorizeTokenObjects(index, (OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBindingRestriction){setToRoleBindingRestrictionObjects(index, (RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){setToImageStreamTagObjects(index, (ImageStreamTag)item);}
 else if (item instanceof Group){setToGroupObjects(index, (Group)item);}
 else if (item instanceof TokenReview){setToTokenReviewObjects(index, (TokenReview)item);}
 else if (item instanceof ImageSignature){setToImageSignatureObjects(index, (ImageSignature)item);}
 else if (item instanceof SecurityContextConstraints){setToSecurityContextConstraintsObjects(index, (SecurityContextConstraints)item);}
 else if (item instanceof ClusterRoleBinding){setToClusterRoleBindingObjects(index, (ClusterRoleBinding)item);}
 else if (item instanceof BuildRequest){setToBuildRequestObjects(index, (BuildRequest)item);}
 else if (item instanceof NetNamespace){setToNetNamespaceObjects(index, (NetNamespace)item);}
 else if (item instanceof ImageStream){setToImageStreamObjects(index, (ImageStream)item);}
 else if (item instanceof ProjectRequest){setToProjectRequestObjects(index, (ProjectRequest)item);}
 else if (item instanceof Template){setToTemplateObjects(index, (Template)item);}
 else if (item instanceof OAuthClientAuthorization){setToOAuthClientAuthorizationObjects(index, (OAuthClientAuthorization)item);}
 else if (item instanceof OAuthClient){setToOAuthClientObjects(index, (OAuthClient)item);}
 else if (item instanceof Identity){setToIdentityObjects(index, (Identity)item);}
 else if (item instanceof ClusterRole){setToClusterRoleObjects(index, (ClusterRole)item);}

            return (A)this;
    }

    public A addToObjects(HasMetadata... items){
             if (items != null && items.length > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (HasMetadata item : items) { 
            if (item instanceof ClusterVersion){addToClusterVersionObjects((ClusterVersion)item);}
 else if (item instanceof ImageStreamImport){addToImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof Role){addToRoleObjects((Role)item);}
 else if (item instanceof Project){addToProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof User){addToUserObjects((User)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupObjects((Group)item);}
 else if (item instanceof TokenReview){addToTokenReviewObjects((TokenReview)item);}
 else if (item instanceof ImageSignature){addToImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof NetNamespace){addToNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){addToIdentityObjects((Identity)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects((ClusterRole)item);}

            else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
            } return (A)this;
    }

    public A addAllToObjects(Collection<HasMetadata> items){
             if (items != null && items.size() > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (HasMetadata item : items) { 
            if (item instanceof ClusterVersion){addToClusterVersionObjects((ClusterVersion)item);}
 else if (item instanceof ImageStreamImport){addToImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof Role){addToRoleObjects((Role)item);}
 else if (item instanceof Project){addToProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof User){addToUserObjects((User)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupObjects((Group)item);}
 else if (item instanceof TokenReview){addToTokenReviewObjects((TokenReview)item);}
 else if (item instanceof ImageSignature){addToImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof NetNamespace){addToNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){addToIdentityObjects((Identity)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects((ClusterRole)item);}

            else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
            } return (A)this;
    }

    public A removeFromObjects(VisitableBuilder<? extends HasMetadata,?> builder){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            _visitables.get("objects").remove(builder);this.objects.remove(builder); return (A)this;
    }

    public A removeFromObjects(HasMetadata... items){
            for (HasMetadata item : items) {if (item instanceof ClusterVersion){removeFromClusterVersionObjects((ClusterVersion)item);}
 else if (item instanceof ImageStreamImport){removeFromImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){removeFromImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof Role){removeFromRoleObjects((Role)item);}
 else if (item instanceof Project){removeFromProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof User){removeFromUserObjects((User)item);}
 else if (item instanceof Route){removeFromRouteObjects((Route)item);}
 else if (item instanceof Build){removeFromBuildObjects((Build)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBindingRestriction){removeFromRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupObjects((Group)item);}
 else if (item instanceof TokenReview){removeFromTokenReviewObjects((TokenReview)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof NetNamespace){removeFromNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof ImageStream){removeFromImageStreamObjects((ImageStream)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){removeFromIdentityObjects((Identity)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleObjects((ClusterRole)item);}

            else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
            } return (A)this;
    }

    public A removeAllFromObjects(Collection<HasMetadata> items){
            for (HasMetadata item : items) {if (item instanceof ClusterVersion){removeFromClusterVersionObjects((ClusterVersion)item);}
 else if (item instanceof ImageStreamImport){removeFromImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){removeFromImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof Role){removeFromRoleObjects((Role)item);}
 else if (item instanceof Project){removeFromProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof User){removeFromUserObjects((User)item);}
 else if (item instanceof Route){removeFromRouteObjects((Route)item);}
 else if (item instanceof Build){removeFromBuildObjects((Build)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof RoleBindingRestriction){removeFromRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupObjects((Group)item);}
 else if (item instanceof TokenReview){removeFromTokenReviewObjects((TokenReview)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof NetNamespace){removeFromNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof ImageStream){removeFromImageStreamObjects((ImageStream)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){removeFromIdentityObjects((Identity)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleObjects((ClusterRole)item);}

            else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
            } return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildObjects instead.
 * @return The buildable object.
 */
@Deprecated public List<HasMetadata> getObjects(){
            return build(objects);
    }

    public List<HasMetadata> buildObjects(){
            return build(objects);
    }

    public HasMetadata buildObject(int index){
            return this.objects.get(index).build();
    }

    public HasMetadata buildFirstObject(){
            return this.objects.get(0).build();
    }

    public HasMetadata buildLastObject(){
            return this.objects.get(objects.size() - 1).build();
    }

    public HasMetadata buildMatchingObject(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            for (VisitableBuilder<? extends HasMetadata,?> item: objects) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingObject(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            for (VisitableBuilder<? extends HasMetadata,?> item: objects) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withObjects(List<HasMetadata> objects){
            if (this.objects != null) { _visitables.get("objects").removeAll(this.objects);}
            if (objects != null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>(); for (HasMetadata item : objects){this.addToObjects(item);}} else { this.objects = null;} return (A) this;
    }

    public A withObjects(HasMetadata... objects){
            if (this.objects != null) {this.objects.clear();}
            if (objects != null) {for (HasMetadata item :objects){ this.addToObjects(item);}} return (A) this;
    }

    public Boolean hasObjects(){
            return objects != null && !objects.isEmpty();
    }

    public A addToClusterVersionObjects(int index,ClusterVersion item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToClusterVersionObjects(int index,ClusterVersion item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToClusterVersionObjects(ClusterVersion... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToClusterVersionObjects(Collection<ClusterVersion> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromClusterVersionObjects(ClusterVersion... items){
            for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterVersionObjects(Collection<ClusterVersion> items){
            for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterVersionObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObject(){
            return new ClusterVersionObjectsNestedImpl();
    }

    public TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObjectLike(ClusterVersion item){
            return new ClusterVersionObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ClusterVersionObjectsNested<A> setNewClusterVersionObjectLike(int index,ClusterVersion item){
            return new ClusterVersionObjectsNestedImpl(index, item);
    }

    public A addToImageStreamImportObjects(int index,ImageStreamImport item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToImageStreamImportObjects(int index,ImageStreamImport item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToImageStreamImportObjects(ImageStreamImport... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToImageStreamImportObjects(Collection<ImageStreamImport> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageStreamImportObjects(ImageStreamImport... items){
            for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromImageStreamImportObjects(Collection<ImageStreamImport> items){
            for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImageStreamImportObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObject(){
            return new ImageStreamImportObjectsNestedImpl();
    }

    public TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObjectLike(ImageStreamImport item){
            return new ImageStreamImportObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ImageStreamImportObjectsNested<A> setNewImageStreamImportObjectLike(int index,ImageStreamImport item){
            return new ImageStreamImportObjectsNestedImpl(index, item);
    }

    public A addToDeploymentConfigObjects(int index,DeploymentConfig item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToDeploymentConfigObjects(int index,DeploymentConfig item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToDeploymentConfigObjects(DeploymentConfig... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToDeploymentConfigObjects(Collection<DeploymentConfig> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromDeploymentConfigObjects(DeploymentConfig... items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromDeploymentConfigObjects(Collection<DeploymentConfig> items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDeploymentConfigObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject(){
            return new DeploymentConfigObjectsNestedImpl();
    }

    public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(DeploymentConfig item){
            return new DeploymentConfigObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.DeploymentConfigObjectsNested<A> setNewDeploymentConfigObjectLike(int index,DeploymentConfig item){
            return new DeploymentConfigObjectsNestedImpl(index, item);
    }

    public A addToOAuthAccessTokenObjects(int index,OAuthAccessToken item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToOAuthAccessTokenObjects(int index,OAuthAccessToken item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthAccessTokenObjects(OAuthAccessToken... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToOAuthAccessTokenObjects(Collection<OAuthAccessToken> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthAccessTokenObjects(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromOAuthAccessTokenObjects(Collection<OAuthAccessToken> items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOAuthAccessTokenObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject(){
            return new OAuthAccessTokenObjectsNestedImpl();
    }

    public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(OAuthAccessToken item){
            return new OAuthAccessTokenObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.OAuthAccessTokenObjectsNested<A> setNewOAuthAccessTokenObjectLike(int index,OAuthAccessToken item){
            return new OAuthAccessTokenObjectsNestedImpl(index, item);
    }

    public A addToRoleBindingObjects(int index,RoleBinding item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToRoleBindingObjects(int index,RoleBinding item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RoleBindingBuilder builder = new RoleBindingBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToRoleBindingObjects(RoleBinding... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToRoleBindingObjects(Collection<RoleBinding> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromRoleBindingObjects(RoleBinding... items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoleBindingObjects(Collection<RoleBinding> items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRoleBindingObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObject(){
            return new RoleBindingObjectsNestedImpl();
    }

    public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(RoleBinding item){
            return new RoleBindingObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.RoleBindingObjectsNested<A> setNewRoleBindingObjectLike(int index,RoleBinding item){
            return new RoleBindingObjectsNestedImpl(index, item);
    }

    public A addToImageObjects(int index,Image item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToImageObjects(int index,Image item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageBuilder builder = new ImageBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToImageObjects(Image... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToImageObjects(Collection<Image> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageObjects(Image... items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromImageObjects(Collection<Image> items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImageObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ImageObjectsNested<A> addNewImageObject(){
            return new ImageObjectsNestedImpl();
    }

    public TemplateFluent.ImageObjectsNested<A> addNewImageObjectLike(Image item){
            return new ImageObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ImageObjectsNested<A> setNewImageObjectLike(int index,Image item){
            return new ImageObjectsNestedImpl(index, item);
    }

    public A addToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToPersistentVolumeClaimObjects(PersistentVolumeClaim... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeClaimObjects(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject(){
            return new PersistentVolumeClaimObjectsNestedImpl();
    }

    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(int index,PersistentVolumeClaim item){
            return new PersistentVolumeClaimObjectsNestedImpl(index, item);
    }

    public A addToRoleObjects(int index,Role item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToRoleObjects(int index,Role item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RoleBuilder builder = new RoleBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToRoleObjects(Role... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToRoleObjects(Collection<Role> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromRoleObjects(Role... items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoleObjects(Collection<Role> items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRoleObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.RoleObjectsNested<A> addNewRoleObject(){
            return new RoleObjectsNestedImpl();
    }

    public TemplateFluent.RoleObjectsNested<A> addNewRoleObjectLike(Role item){
            return new RoleObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.RoleObjectsNested<A> setNewRoleObjectLike(int index,Role item){
            return new RoleObjectsNestedImpl(index, item);
    }

    public A addToProjectObjects(int index,Project item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToProjectObjects(int index,Project item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ProjectBuilder builder = new ProjectBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToProjectObjects(Project... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToProjectObjects(Collection<Project> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromProjectObjects(Project... items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromProjectObjects(Collection<Project> items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromProjectObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ProjectObjectsNested<A> addNewProjectObject(){
            return new ProjectObjectsNestedImpl();
    }

    public TemplateFluent.ProjectObjectsNested<A> addNewProjectObjectLike(Project item){
            return new ProjectObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ProjectObjectsNested<A> setNewProjectObjectLike(int index,Project item){
            return new ProjectObjectsNestedImpl(index, item);
    }

    public A addToBuildConfigObjects(int index,BuildConfig item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToBuildConfigObjects(int index,BuildConfig item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToBuildConfigObjects(BuildConfig... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToBuildConfigObjects(Collection<BuildConfig> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromBuildConfigObjects(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromBuildConfigObjects(Collection<BuildConfig> items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBuildConfigObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObject(){
            return new BuildConfigObjectsNestedImpl();
    }

    public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(BuildConfig item){
            return new BuildConfigObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.BuildConfigObjectsNested<A> setNewBuildConfigObjectLike(int index,BuildConfig item){
            return new BuildConfigObjectsNestedImpl(index, item);
    }

    public A addToUserObjects(int index,User item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            UserBuilder builder = new UserBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToUserObjects(int index,User item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            UserBuilder builder = new UserBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToUserObjects(User... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToUserObjects(Collection<User> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromUserObjects(User... items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromUserObjects(Collection<User> items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromUserObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.UserObjectsNested<A> addNewUserObject(){
            return new UserObjectsNestedImpl();
    }

    public TemplateFluent.UserObjectsNested<A> addNewUserObjectLike(User item){
            return new UserObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.UserObjectsNested<A> setNewUserObjectLike(int index,User item){
            return new UserObjectsNestedImpl(index, item);
    }

    public A addToRouteObjects(int index,Route item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToRouteObjects(int index,Route item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RouteBuilder builder = new RouteBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToRouteObjects(Route... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToRouteObjects(Collection<Route> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromRouteObjects(Route... items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromRouteObjects(Collection<Route> items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRouteObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.RouteObjectsNested<A> addNewRouteObject(){
            return new RouteObjectsNestedImpl();
    }

    public TemplateFluent.RouteObjectsNested<A> addNewRouteObjectLike(Route item){
            return new RouteObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.RouteObjectsNested<A> setNewRouteObjectLike(int index,Route item){
            return new RouteObjectsNestedImpl(index, item);
    }

    public A addToBuildObjects(int index,Build item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToBuildObjects(int index,Build item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            BuildBuilder builder = new BuildBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToBuildObjects(Build... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToBuildObjects(Collection<Build> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromBuildObjects(Build... items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromBuildObjects(Collection<Build> items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBuildObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.BuildObjectsNested<A> addNewBuildObject(){
            return new BuildObjectsNestedImpl();
    }

    public TemplateFluent.BuildObjectsNested<A> addNewBuildObjectLike(Build item){
            return new BuildObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.BuildObjectsNested<A> setNewBuildObjectLike(int index,Build item){
            return new BuildObjectsNestedImpl(index, item);
    }

    public A addToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOAuthAuthorizeTokenObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject(){
            return new OAuthAuthorizeTokenObjectsNestedImpl();
    }

    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> setNewOAuthAuthorizeTokenObjectLike(int index,OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenObjectsNestedImpl(index, item);
    }

    public A addToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToRoleBindingRestrictionObjects(RoleBindingRestriction... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromRoleBindingRestrictionObjects(RoleBindingRestriction... items){
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items){
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRoleBindingRestrictionObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObject(){
            return new RoleBindingRestrictionObjectsNestedImpl();
    }

    public TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObjectLike(RoleBindingRestriction item){
            return new RoleBindingRestrictionObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.RoleBindingRestrictionObjectsNested<A> setNewRoleBindingRestrictionObjectLike(int index,RoleBindingRestriction item){
            return new RoleBindingRestrictionObjectsNestedImpl(index, item);
    }

    public A addToImageStreamTagObjects(int index,ImageStreamTag item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToImageStreamTagObjects(int index,ImageStreamTag item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToImageStreamTagObjects(ImageStreamTag... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToImageStreamTagObjects(Collection<ImageStreamTag> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageStreamTagObjects(ImageStreamTag... items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromImageStreamTagObjects(Collection<ImageStreamTag> items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImageStreamTagObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObject(){
            return new ImageStreamTagObjectsNestedImpl();
    }

    public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(ImageStreamTag item){
            return new ImageStreamTagObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ImageStreamTagObjectsNested<A> setNewImageStreamTagObjectLike(int index,ImageStreamTag item){
            return new ImageStreamTagObjectsNestedImpl(index, item);
    }

    public A addToGroupObjects(int index,Group item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToGroupObjects(int index,Group item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            GroupBuilder builder = new GroupBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToGroupObjects(Group... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToGroupObjects(Collection<Group> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromGroupObjects(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromGroupObjects(Collection<Group> items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGroupObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.GroupObjectsNested<A> addNewGroupObject(){
            return new GroupObjectsNestedImpl();
    }

    public TemplateFluent.GroupObjectsNested<A> addNewGroupObjectLike(Group item){
            return new GroupObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.GroupObjectsNested<A> setNewGroupObjectLike(int index,Group item){
            return new GroupObjectsNestedImpl(index, item);
    }

    public A addToTokenReviewObjects(int index,TokenReview item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            TokenReviewBuilder builder = new TokenReviewBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToTokenReviewObjects(int index,TokenReview item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            TokenReviewBuilder builder = new TokenReviewBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToTokenReviewObjects(TokenReview... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (TokenReview item : items) {TokenReviewBuilder builder = new TokenReviewBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToTokenReviewObjects(Collection<TokenReview> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (TokenReview item : items) {TokenReviewBuilder builder = new TokenReviewBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromTokenReviewObjects(TokenReview... items){
            for (TokenReview item : items) {TokenReviewBuilder builder = new TokenReviewBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromTokenReviewObjects(Collection<TokenReview> items){
            for (TokenReview item : items) {TokenReviewBuilder builder = new TokenReviewBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTokenReviewObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.TokenReviewObjectsNested<A> addNewTokenReviewObject(){
            return new TokenReviewObjectsNestedImpl();
    }

    public TemplateFluent.TokenReviewObjectsNested<A> addNewTokenReviewObjectLike(TokenReview item){
            return new TokenReviewObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.TokenReviewObjectsNested<A> setNewTokenReviewObjectLike(int index,TokenReview item){
            return new TokenReviewObjectsNestedImpl(index, item);
    }

    public A addToImageSignatureObjects(int index,ImageSignature item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToImageSignatureObjects(int index,ImageSignature item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToImageSignatureObjects(ImageSignature... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToImageSignatureObjects(Collection<ImageSignature> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageSignatureObjects(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromImageSignatureObjects(Collection<ImageSignature> items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImageSignatureObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObject(){
            return new ImageSignatureObjectsNestedImpl();
    }

    public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(ImageSignature item){
            return new ImageSignatureObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ImageSignatureObjectsNested<A> setNewImageSignatureObjectLike(int index,ImageSignature item){
            return new ImageSignatureObjectsNestedImpl(index, item);
    }

    public A addToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToSecurityContextConstraintsObjects(SecurityContextConstraints... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromSecurityContextConstraintsObjects(SecurityContextConstraints... items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSecurityContextConstraintsObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject(){
            return new SecurityContextConstraintsObjectsNestedImpl();
    }

    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> setNewSecurityContextConstraintsObjectLike(int index,SecurityContextConstraints item){
            return new SecurityContextConstraintsObjectsNestedImpl(index, item);
    }

    public A addToClusterRoleBindingObjects(int index,ClusterRoleBinding item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToClusterRoleBindingObjects(int index,ClusterRoleBinding item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToClusterRoleBindingObjects(ClusterRoleBinding... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToClusterRoleBindingObjects(Collection<ClusterRoleBinding> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleBindingObjects(ClusterRoleBinding... items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterRoleBindingObjects(Collection<ClusterRoleBinding> items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterRoleBindingObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject(){
            return new ClusterRoleBindingObjectsNestedImpl();
    }

    public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(ClusterRoleBinding item){
            return new ClusterRoleBindingObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ClusterRoleBindingObjectsNested<A> setNewClusterRoleBindingObjectLike(int index,ClusterRoleBinding item){
            return new ClusterRoleBindingObjectsNestedImpl(index, item);
    }

    public A addToBuildRequestObjects(int index,BuildRequest item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToBuildRequestObjects(int index,BuildRequest item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            BuildRequestBuilder builder = new BuildRequestBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToBuildRequestObjects(BuildRequest... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToBuildRequestObjects(Collection<BuildRequest> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromBuildRequestObjects(BuildRequest... items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromBuildRequestObjects(Collection<BuildRequest> items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBuildRequestObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObject(){
            return new BuildRequestObjectsNestedImpl();
    }

    public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(BuildRequest item){
            return new BuildRequestObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.BuildRequestObjectsNested<A> setNewBuildRequestObjectLike(int index,BuildRequest item){
            return new BuildRequestObjectsNestedImpl(index, item);
    }

    public A addToNetNamespaceObjects(int index,NetNamespace item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToNetNamespaceObjects(int index,NetNamespace item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToNetNamespaceObjects(NetNamespace... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToNetNamespaceObjects(Collection<NetNamespace> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromNetNamespaceObjects(NetNamespace... items){
            for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromNetNamespaceObjects(Collection<NetNamespace> items){
            for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNetNamespaceObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObject(){
            return new NetNamespaceObjectsNestedImpl();
    }

    public TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObjectLike(NetNamespace item){
            return new NetNamespaceObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.NetNamespaceObjectsNested<A> setNewNetNamespaceObjectLike(int index,NetNamespace item){
            return new NetNamespaceObjectsNestedImpl(index, item);
    }

    public A addToImageStreamObjects(int index,ImageStream item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToImageStreamObjects(int index,ImageStream item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToImageStreamObjects(ImageStream... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToImageStreamObjects(Collection<ImageStream> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromImageStreamObjects(ImageStream... items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromImageStreamObjects(Collection<ImageStream> items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImageStreamObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObject(){
            return new ImageStreamObjectsNestedImpl();
    }

    public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObjectLike(ImageStream item){
            return new ImageStreamObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ImageStreamObjectsNested<A> setNewImageStreamObjectLike(int index,ImageStream item){
            return new ImageStreamObjectsNestedImpl(index, item);
    }

    public A addToProjectRequestObjects(int index,ProjectRequest item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToProjectRequestObjects(int index,ProjectRequest item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ProjectRequestBuilder builder = new ProjectRequestBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToProjectRequestObjects(ProjectRequest... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToProjectRequestObjects(Collection<ProjectRequest> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromProjectRequestObjects(ProjectRequest... items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromProjectRequestObjects(Collection<ProjectRequest> items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromProjectRequestObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObject(){
            return new ProjectRequestObjectsNestedImpl();
    }

    public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(ProjectRequest item){
            return new ProjectRequestObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ProjectRequestObjectsNested<A> setNewProjectRequestObjectLike(int index,ProjectRequest item){
            return new ProjectRequestObjectsNestedImpl(index, item);
    }

    public A addToTemplateObjects(int index,Template item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToTemplateObjects(int index,Template item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            TemplateBuilder builder = new TemplateBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToTemplateObjects(Template... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToTemplateObjects(Collection<Template> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromTemplateObjects(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromTemplateObjects(Collection<Template> items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTemplateObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObject(){
            return new TemplateObjectsNestedImpl();
    }

    public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObjectLike(Template item){
            return new TemplateObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.TemplateObjectsNested<A> setNewTemplateObjectLike(int index,Template item){
            return new TemplateObjectsNestedImpl(index, item);
    }

    public A addToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthClientAuthorizationObjects(OAuthClientAuthorization... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientAuthorizationObjects(OAuthClientAuthorization... items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOAuthClientAuthorizationObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject(){
            return new OAuthClientAuthorizationObjectsNestedImpl();
    }

    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> setNewOAuthClientAuthorizationObjectLike(int index,OAuthClientAuthorization item){
            return new OAuthClientAuthorizationObjectsNestedImpl(index, item);
    }

    public A addToOAuthClientObjects(int index,OAuthClient item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToOAuthClientObjects(int index,OAuthClient item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            OAuthClientBuilder builder = new OAuthClientBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthClientObjects(OAuthClient... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToOAuthClientObjects(Collection<OAuthClient> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientObjects(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromOAuthClientObjects(Collection<OAuthClient> items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOAuthClientObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObject(){
            return new OAuthClientObjectsNestedImpl();
    }

    public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(OAuthClient item){
            return new OAuthClientObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.OAuthClientObjectsNested<A> setNewOAuthClientObjectLike(int index,OAuthClient item){
            return new OAuthClientObjectsNestedImpl(index, item);
    }

    public A addToIdentityObjects(int index,Identity item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToIdentityObjects(int index,Identity item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            IdentityBuilder builder = new IdentityBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToIdentityObjects(Identity... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToIdentityObjects(Collection<Identity> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromIdentityObjects(Identity... items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromIdentityObjects(Collection<Identity> items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIdentityObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObject(){
            return new IdentityObjectsNestedImpl();
    }

    public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObjectLike(Identity item){
            return new IdentityObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.IdentityObjectsNested<A> setNewIdentityObjectLike(int index,Identity item){
            return new IdentityObjectsNestedImpl(index, item);
    }

    public A addToClusterRoleObjects(int index,ClusterRole item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToClusterRoleObjects(int index,ClusterRole item){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            ClusterRoleBuilder builder = new ClusterRoleBuilder(item);
            if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
            if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
             return (A)this;
    }

    public A addToClusterRoleObjects(ClusterRole... items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToClusterRoleObjects(Collection<ClusterRole> items){
            if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleObjects(ClusterRole... items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterRoleObjects(Collection<ClusterRole> items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterRoleObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            if (objects == null) return (A) this;
            final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
            final List visitables = _visitables.get("objects");
            while (each.hasNext()) {
              VisitableBuilder<? extends HasMetadata,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObject(){
            return new ClusterRoleObjectsNestedImpl();
    }

    public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(ClusterRole item){
            return new ClusterRoleObjectsNestedImpl(-1, item);
    }

    public TemplateFluent.ClusterRoleObjectsNested<A> setNewClusterRoleObjectLike(int index,ClusterRole item){
            return new ClusterRoleObjectsNestedImpl(index, item);
    }

    public A addToParameters(int index,Parameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
            ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").add(index >= 0 ? index : _visitables.get("parameters").size(), builder);this.parameters.add(index >= 0 ? index : parameters.size(), builder); return (A)this;
    }

    public A setToParameters(int index,Parameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
            ParameterBuilder builder = new ParameterBuilder(item);
            if (index < 0 || index >= _visitables.get("parameters").size()) { _visitables.get("parameters").add(builder); } else { _visitables.get("parameters").set(index, builder);}
            if (index < 0 || index >= parameters.size()) { parameters.add(builder); } else { parameters.set(index, builder);}
             return (A)this;
    }

    public A addToParameters(Parameter... items){
            if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
            for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A addAllToParameters(Collection<Parameter> items){
            if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
            for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A removeFromParameters(Parameter... items){
            for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeAllFromParameters(Collection<Parameter> items){
            for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromParameters(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate){
            if (parameters == null) return (A) this;
            final Iterator<ParameterBuilder> each = parameters.iterator();
            final List visitables = _visitables.get("parameters");
            while (each.hasNext()) {
              ParameterBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParameters instead.
 * @return The buildable object.
 */
@Deprecated public List<Parameter> getParameters(){
            return build(parameters);
    }

    public List<Parameter> buildParameters(){
            return build(parameters);
    }

    public Parameter buildParameter(int index){
            return this.parameters.get(index).build();
    }

    public Parameter buildFirstParameter(){
            return this.parameters.get(0).build();
    }

    public Parameter buildLastParameter(){
            return this.parameters.get(parameters.size() - 1).build();
    }

    public Parameter buildMatchingParameter(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate){
            for (ParameterBuilder item: parameters) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingParameter(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate){
            for (ParameterBuilder item: parameters) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withParameters(List<Parameter> parameters){
            if (this.parameters != null) { _visitables.get("parameters").removeAll(this.parameters);}
            if (parameters != null) {this.parameters = new ArrayList<ParameterBuilder>(); for (Parameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
    }

    public A withParameters(Parameter... parameters){
            if (this.parameters != null) {this.parameters.clear();}
            if (parameters != null) {for (Parameter item :parameters){ this.addToParameters(item);}} return (A) this;
    }

    public Boolean hasParameters(){
            return parameters != null && !parameters.isEmpty();
    }

    public TemplateFluent.ParametersNested<A> addNewParameter(){
            return new ParametersNestedImpl();
    }

    public TemplateFluent.ParametersNested<A> addNewParameterLike(Parameter item){
            return new ParametersNestedImpl(-1, item);
    }

    public TemplateFluent.ParametersNested<A> setNewParameterLike(int index,Parameter item){
            return new ParametersNestedImpl(index, item);
    }

    public TemplateFluent.ParametersNested<A> editParameter(int index){
            if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public TemplateFluent.ParametersNested<A> editFirstParameter(){
            if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
            return setNewParameterLike(0, buildParameter(0));
    }

    public TemplateFluent.ParametersNested<A> editLastParameter(){
            int index = parameters.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public TemplateFluent.ParametersNested<A> editMatchingParameter(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate){
            int index = -1;
            for (int i=0;i<parameters.size();i++) { 
            if (predicate.apply(parameters.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TemplateFluentImpl that = (TemplateFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (objects != null ? !objects.equals(that.objects) :that.objects != null) return false;
            if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<TemplateFluent.MetadataNested<N>> implements TemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class ClusterVersionObjectsNestedImpl<N> extends ClusterVersionFluentImpl<TemplateFluent.ClusterVersionObjectsNested<N>> implements TemplateFluent.ClusterVersionObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterVersionBuilder builder;
        private final int index;
    
            ClusterVersionObjectsNestedImpl(int index,ClusterVersion item){
                    this.index = index;
                    this.builder = new ClusterVersionBuilder(this, item);
            }
            ClusterVersionObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterVersionBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterVersionObject(){
            return and();
    }

}
    public class ImageStreamImportObjectsNestedImpl<N> extends ImageStreamImportFluentImpl<TemplateFluent.ImageStreamImportObjectsNested<N>> implements TemplateFluent.ImageStreamImportObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamImportBuilder builder;
        private final int index;
    
            ImageStreamImportObjectsNestedImpl(int index,ImageStreamImport item){
                    this.index = index;
                    this.builder = new ImageStreamImportBuilder(this, item);
            }
            ImageStreamImportObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageStreamImportBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamImportObject(){
            return and();
    }

}
    public class DeploymentConfigObjectsNestedImpl<N> extends DeploymentConfigFluentImpl<TemplateFluent.DeploymentConfigObjectsNested<N>> implements TemplateFluent.DeploymentConfigObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentConfigBuilder builder;
        private final int index;
    
            DeploymentConfigObjectsNestedImpl(int index,DeploymentConfig item){
                    this.index = index;
                    this.builder = new DeploymentConfigBuilder(this, item);
            }
            DeploymentConfigObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new DeploymentConfigBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endDeploymentConfigObject(){
            return and();
    }

}
    public class OAuthAccessTokenObjectsNestedImpl<N> extends OAuthAccessTokenFluentImpl<TemplateFluent.OAuthAccessTokenObjectsNested<N>> implements TemplateFluent.OAuthAccessTokenObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAccessTokenBuilder builder;
        private final int index;
    
            OAuthAccessTokenObjectsNestedImpl(int index,OAuthAccessToken item){
                    this.index = index;
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
            OAuthAccessTokenObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthAccessTokenObject(){
            return and();
    }

}
    public class RoleBindingObjectsNestedImpl<N> extends RoleBindingFluentImpl<TemplateFluent.RoleBindingObjectsNested<N>> implements TemplateFluent.RoleBindingObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingBuilder builder;
        private final int index;
    
            RoleBindingObjectsNestedImpl(int index,RoleBinding item){
                    this.index = index;
                    this.builder = new RoleBindingBuilder(this, item);
            }
            RoleBindingObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new RoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingObject(){
            return and();
    }

}
    public class ImageObjectsNestedImpl<N> extends ImageFluentImpl<TemplateFluent.ImageObjectsNested<N>> implements TemplateFluent.ImageObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageBuilder builder;
        private final int index;
    
            ImageObjectsNestedImpl(int index,Image item){
                    this.index = index;
                    this.builder = new ImageBuilder(this, item);
            }
            ImageObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageObject(){
            return and();
    }

}
    public class PersistentVolumeClaimObjectsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<TemplateFluent.PersistentVolumeClaimObjectsNested<N>> implements TemplateFluent.PersistentVolumeClaimObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
        private final int index;
    
            PersistentVolumeClaimObjectsNestedImpl(int index,PersistentVolumeClaim item){
                    this.index = index;
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
            PersistentVolumeClaimObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endPersistentVolumeClaimObject(){
            return and();
    }

}
    public class RoleObjectsNestedImpl<N> extends RoleFluentImpl<TemplateFluent.RoleObjectsNested<N>> implements TemplateFluent.RoleObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBuilder builder;
        private final int index;
    
            RoleObjectsNestedImpl(int index,Role item){
                    this.index = index;
                    this.builder = new RoleBuilder(this, item);
            }
            RoleObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new RoleBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleObject(){
            return and();
    }

}
    public class ProjectObjectsNestedImpl<N> extends ProjectFluentImpl<TemplateFluent.ProjectObjectsNested<N>> implements TemplateFluent.ProjectObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectBuilder builder;
        private final int index;
    
            ProjectObjectsNestedImpl(int index,Project item){
                    this.index = index;
                    this.builder = new ProjectBuilder(this, item);
            }
            ProjectObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ProjectBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endProjectObject(){
            return and();
    }

}
    public class BuildConfigObjectsNestedImpl<N> extends BuildConfigFluentImpl<TemplateFluent.BuildConfigObjectsNested<N>> implements TemplateFluent.BuildConfigObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildConfigBuilder builder;
        private final int index;
    
            BuildConfigObjectsNestedImpl(int index,BuildConfig item){
                    this.index = index;
                    this.builder = new BuildConfigBuilder(this, item);
            }
            BuildConfigObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new BuildConfigBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildConfigObject(){
            return and();
    }

}
    public class UserObjectsNestedImpl<N> extends UserFluentImpl<TemplateFluent.UserObjectsNested<N>> implements TemplateFluent.UserObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UserBuilder builder;
        private final int index;
    
            UserObjectsNestedImpl(int index,User item){
                    this.index = index;
                    this.builder = new UserBuilder(this, item);
            }
            UserObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new UserBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endUserObject(){
            return and();
    }

}
    public class RouteObjectsNestedImpl<N> extends RouteFluentImpl<TemplateFluent.RouteObjectsNested<N>> implements TemplateFluent.RouteObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteBuilder builder;
        private final int index;
    
            RouteObjectsNestedImpl(int index,Route item){
                    this.index = index;
                    this.builder = new RouteBuilder(this, item);
            }
            RouteObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new RouteBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRouteObject(){
            return and();
    }

}
    public class BuildObjectsNestedImpl<N> extends BuildFluentImpl<TemplateFluent.BuildObjectsNested<N>> implements TemplateFluent.BuildObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildBuilder builder;
        private final int index;
    
            BuildObjectsNestedImpl(int index,Build item){
                    this.index = index;
                    this.builder = new BuildBuilder(this, item);
            }
            BuildObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new BuildBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildObject(){
            return and();
    }

}
    public class OAuthAuthorizeTokenObjectsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>> implements TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
        private final int index;
    
            OAuthAuthorizeTokenObjectsNestedImpl(int index,OAuthAuthorizeToken item){
                    this.index = index;
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
            OAuthAuthorizeTokenObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthAuthorizeTokenObject(){
            return and();
    }

}
    public class RoleBindingRestrictionObjectsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<TemplateFluent.RoleBindingRestrictionObjectsNested<N>> implements TemplateFluent.RoleBindingRestrictionObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingRestrictionBuilder builder;
        private final int index;
    
            RoleBindingRestrictionObjectsNestedImpl(int index,RoleBindingRestriction item){
                    this.index = index;
                    this.builder = new RoleBindingRestrictionBuilder(this, item);
            }
            RoleBindingRestrictionObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new RoleBindingRestrictionBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingRestrictionObject(){
            return and();
    }

}
    public class ImageStreamTagObjectsNestedImpl<N> extends ImageStreamTagFluentImpl<TemplateFluent.ImageStreamTagObjectsNested<N>> implements TemplateFluent.ImageStreamTagObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamTagBuilder builder;
        private final int index;
    
            ImageStreamTagObjectsNestedImpl(int index,ImageStreamTag item){
                    this.index = index;
                    this.builder = new ImageStreamTagBuilder(this, item);
            }
            ImageStreamTagObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageStreamTagBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamTagObject(){
            return and();
    }

}
    public class GroupObjectsNestedImpl<N> extends GroupFluentImpl<TemplateFluent.GroupObjectsNested<N>> implements TemplateFluent.GroupObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GroupBuilder builder;
        private final int index;
    
            GroupObjectsNestedImpl(int index,Group item){
                    this.index = index;
                    this.builder = new GroupBuilder(this, item);
            }
            GroupObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new GroupBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endGroupObject(){
            return and();
    }

}
    public class TokenReviewObjectsNestedImpl<N> extends TokenReviewFluentImpl<TemplateFluent.TokenReviewObjectsNested<N>> implements TemplateFluent.TokenReviewObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TokenReviewBuilder builder;
        private final int index;
    
            TokenReviewObjectsNestedImpl(int index,TokenReview item){
                    this.index = index;
                    this.builder = new TokenReviewBuilder(this, item);
            }
            TokenReviewObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new TokenReviewBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endTokenReviewObject(){
            return and();
    }

}
    public class ImageSignatureObjectsNestedImpl<N> extends ImageSignatureFluentImpl<TemplateFluent.ImageSignatureObjectsNested<N>> implements TemplateFluent.ImageSignatureObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSignatureBuilder builder;
        private final int index;
    
            ImageSignatureObjectsNestedImpl(int index,ImageSignature item){
                    this.index = index;
                    this.builder = new ImageSignatureBuilder(this, item);
            }
            ImageSignatureObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageSignatureBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageSignatureObject(){
            return and();
    }

}
    public class SecurityContextConstraintsObjectsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<TemplateFluent.SecurityContextConstraintsObjectsNested<N>> implements TemplateFluent.SecurityContextConstraintsObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
        private final int index;
    
            SecurityContextConstraintsObjectsNestedImpl(int index,SecurityContextConstraints item){
                    this.index = index;
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
            SecurityContextConstraintsObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endSecurityContextConstraintsObject(){
            return and();
    }

}
    public class ClusterRoleBindingObjectsNestedImpl<N> extends ClusterRoleBindingFluentImpl<TemplateFluent.ClusterRoleBindingObjectsNested<N>> implements TemplateFluent.ClusterRoleBindingObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBindingBuilder builder;
        private final int index;
    
            ClusterRoleBindingObjectsNestedImpl(int index,ClusterRoleBinding item){
                    this.index = index;
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
            ClusterRoleBindingObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleBindingObject(){
            return and();
    }

}
    public class BuildRequestObjectsNestedImpl<N> extends BuildRequestFluentImpl<TemplateFluent.BuildRequestObjectsNested<N>> implements TemplateFluent.BuildRequestObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildRequestBuilder builder;
        private final int index;
    
            BuildRequestObjectsNestedImpl(int index,BuildRequest item){
                    this.index = index;
                    this.builder = new BuildRequestBuilder(this, item);
            }
            BuildRequestObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new BuildRequestBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildRequestObject(){
            return and();
    }

}
    public class NetNamespaceObjectsNestedImpl<N> extends NetNamespaceFluentImpl<TemplateFluent.NetNamespaceObjectsNested<N>> implements TemplateFluent.NetNamespaceObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NetNamespaceBuilder builder;
        private final int index;
    
            NetNamespaceObjectsNestedImpl(int index,NetNamespace item){
                    this.index = index;
                    this.builder = new NetNamespaceBuilder(this, item);
            }
            NetNamespaceObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new NetNamespaceBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endNetNamespaceObject(){
            return and();
    }

}
    public class ImageStreamObjectsNestedImpl<N> extends ImageStreamFluentImpl<TemplateFluent.ImageStreamObjectsNested<N>> implements TemplateFluent.ImageStreamObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamBuilder builder;
        private final int index;
    
            ImageStreamObjectsNestedImpl(int index,ImageStream item){
                    this.index = index;
                    this.builder = new ImageStreamBuilder(this, item);
            }
            ImageStreamObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageStreamBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamObject(){
            return and();
    }

}
    public class ProjectRequestObjectsNestedImpl<N> extends ProjectRequestFluentImpl<TemplateFluent.ProjectRequestObjectsNested<N>> implements TemplateFluent.ProjectRequestObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectRequestBuilder builder;
        private final int index;
    
            ProjectRequestObjectsNestedImpl(int index,ProjectRequest item){
                    this.index = index;
                    this.builder = new ProjectRequestBuilder(this, item);
            }
            ProjectRequestObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ProjectRequestBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endProjectRequestObject(){
            return and();
    }

}
    public class TemplateObjectsNestedImpl<N> extends TemplateFluentImpl<TemplateFluent.TemplateObjectsNested<N>> implements TemplateFluent.TemplateObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TemplateBuilder builder;
        private final int index;
    
            TemplateObjectsNestedImpl(int index,Template item){
                    this.index = index;
                    this.builder = new TemplateBuilder(this, item);
            }
            TemplateObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new TemplateBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endTemplateObject(){
            return and();
    }

}
    public class OAuthClientAuthorizationObjectsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<TemplateFluent.OAuthClientAuthorizationObjectsNested<N>> implements TemplateFluent.OAuthClientAuthorizationObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
        private final int index;
    
            OAuthClientAuthorizationObjectsNestedImpl(int index,OAuthClientAuthorization item){
                    this.index = index;
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
            OAuthClientAuthorizationObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientAuthorizationObject(){
            return and();
    }

}
    public class OAuthClientObjectsNestedImpl<N> extends OAuthClientFluentImpl<TemplateFluent.OAuthClientObjectsNested<N>> implements TemplateFluent.OAuthClientObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientBuilder builder;
        private final int index;
    
            OAuthClientObjectsNestedImpl(int index,OAuthClient item){
                    this.index = index;
                    this.builder = new OAuthClientBuilder(this, item);
            }
            OAuthClientObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthClientBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientObject(){
            return and();
    }

}
    public class IdentityObjectsNestedImpl<N> extends IdentityFluentImpl<TemplateFluent.IdentityObjectsNested<N>> implements TemplateFluent.IdentityObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IdentityBuilder builder;
        private final int index;
    
            IdentityObjectsNestedImpl(int index,Identity item){
                    this.index = index;
                    this.builder = new IdentityBuilder(this, item);
            }
            IdentityObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new IdentityBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endIdentityObject(){
            return and();
    }

}
    public class ClusterRoleObjectsNestedImpl<N> extends ClusterRoleFluentImpl<TemplateFluent.ClusterRoleObjectsNested<N>> implements TemplateFluent.ClusterRoleObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBuilder builder;
        private final int index;
    
            ClusterRoleObjectsNestedImpl(int index,ClusterRole item){
                    this.index = index;
                    this.builder = new ClusterRoleBuilder(this, item);
            }
            ClusterRoleObjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleObject(){
            return and();
    }

}
    public class ParametersNestedImpl<N> extends ParameterFluentImpl<TemplateFluent.ParametersNested<N>> implements TemplateFluent.ParametersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParameterBuilder builder;
        private final int index;
    
            ParametersNestedImpl(int index,Parameter item){
                    this.index = index;
                    this.builder = new ParameterBuilder(this, item);
            }
            ParametersNestedImpl(){
                    this.index = -1;
                    this.builder = new ParameterBuilder(this);
            }
    
    public N and(){
            return (N) TemplateFluentImpl.this.setToParameters(index,builder.build());
    }
    public N endParameter(){
            return and();
    }

}


}
