package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterOperatorSpecBuilder extends ClusterOperatorSpecFluentImpl<ClusterOperatorSpecBuilder> implements VisitableBuilder<ClusterOperatorSpec,ClusterOperatorSpecBuilder>{

    ClusterOperatorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterOperatorSpecBuilder(){
            this(true);
    }
    public ClusterOperatorSpecBuilder(Boolean validationEnabled){
            this(new ClusterOperatorSpec(), validationEnabled);
    }
    public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterOperatorSpec(), validationEnabled);
    }
    public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent,ClusterOperatorSpec instance){
            this(fluent, instance, true);
    }
    public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent,ClusterOperatorSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterOperatorSpecBuilder(ClusterOperatorSpec instance){
            this(instance,true);
    }
    public ClusterOperatorSpecBuilder(ClusterOperatorSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterOperatorSpec build(){
            ClusterOperatorSpec buildable = new ClusterOperatorSpec();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterOperatorSpecBuilder that = (ClusterOperatorSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
