package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageTagBuilder extends ImageTagFluentImpl<ImageTagBuilder> implements VisitableBuilder<ImageTag,ImageTagBuilder>{

    ImageTagFluent<?> fluent;
    Boolean validationEnabled;

    public ImageTagBuilder(){
            this(true);
    }
    public ImageTagBuilder(Boolean validationEnabled){
            this(new ImageTag(), validationEnabled);
    }
    public ImageTagBuilder(ImageTagFluent<?> fluent){
            this(fluent, true);
    }
    public ImageTagBuilder(ImageTagFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageTag(), validationEnabled);
    }
    public ImageTagBuilder(ImageTagFluent<?> fluent,ImageTag instance){
            this(fluent, instance, true);
    }
    public ImageTagBuilder(ImageTagFluent<?> fluent,ImageTag instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withImage(instance.getImage()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageTagBuilder(ImageTag instance){
            this(instance,true);
    }
    public ImageTagBuilder(ImageTag instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withImage(instance.getImage()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ImageTag build(){
            ImageTag buildable = new ImageTag(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageTagBuilder that = (ImageTagBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
