package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorHubSpecBuilder extends OperatorHubSpecFluentImpl<OperatorHubSpecBuilder> implements VisitableBuilder<OperatorHubSpec,OperatorHubSpecBuilder>{

    OperatorHubSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorHubSpecBuilder(){
            this(true);
    }
    public OperatorHubSpecBuilder(Boolean validationEnabled){
            this(new OperatorHubSpec(), validationEnabled);
    }
    public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent){
            this(fluent, true);
    }
    public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OperatorHubSpec(), validationEnabled);
    }
    public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent,OperatorHubSpec instance){
            this(fluent, instance, true);
    }
    public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent,OperatorHubSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDisableAllDefaultSources(instance.getDisableAllDefaultSources()); 
            fluent.withSources(instance.getSources()); 
            this.validationEnabled = validationEnabled; 
    }
    public OperatorHubSpecBuilder(OperatorHubSpec instance){
            this(instance,true);
    }
    public OperatorHubSpecBuilder(OperatorHubSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDisableAllDefaultSources(instance.getDisableAllDefaultSources()); 
            this.withSources(instance.getSources()); 
            this.validationEnabled = validationEnabled; 
    }

    public OperatorHubSpec build(){
            OperatorHubSpec buildable = new OperatorHubSpec(fluent.isDisableAllDefaultSources(),fluent.getSources());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OperatorHubSpecBuilder that = (OperatorHubSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
