package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VSpherePlatformSpecBuilder extends VSpherePlatformSpecFluentImpl<VSpherePlatformSpecBuilder> implements VisitableBuilder<VSpherePlatformSpec,VSpherePlatformSpecBuilder>{

    VSpherePlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public VSpherePlatformSpecBuilder(){
            this(true);
    }
    public VSpherePlatformSpecBuilder(Boolean validationEnabled){
            this(new VSpherePlatformSpec(), validationEnabled);
    }
    public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent){
            this(fluent, true);
    }
    public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VSpherePlatformSpec(), validationEnabled);
    }
    public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,VSpherePlatformSpec instance){
            this(fluent, instance, true);
    }
    public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,VSpherePlatformSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public VSpherePlatformSpecBuilder(VSpherePlatformSpec instance){
            this(instance,true);
    }
    public VSpherePlatformSpecBuilder(VSpherePlatformSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public VSpherePlatformSpec build(){
            VSpherePlatformSpec buildable = new VSpherePlatformSpec();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VSpherePlatformSpecBuilder that = (VSpherePlatformSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
