package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterOperatorStatusConditionBuilder extends ClusterOperatorStatusConditionFluentImpl<ClusterOperatorStatusConditionBuilder> implements VisitableBuilder<ClusterOperatorStatusCondition,ClusterOperatorStatusConditionBuilder>{

    ClusterOperatorStatusConditionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterOperatorStatusConditionBuilder(){
            this(true);
    }
    public ClusterOperatorStatusConditionBuilder(Boolean validationEnabled){
            this(new ClusterOperatorStatusCondition(), validationEnabled);
    }
    public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterOperatorStatusCondition(), validationEnabled);
    }
    public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent,ClusterOperatorStatusCondition instance){
            this(fluent, instance, true);
    }
    public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusConditionFluent<?> fluent,ClusterOperatorStatusCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
            fluent.withMessage(instance.getMessage()); 
            fluent.withReason(instance.getReason()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusCondition instance){
            this(instance,true);
    }
    public ClusterOperatorStatusConditionBuilder(ClusterOperatorStatusCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterOperatorStatusCondition build(){
            ClusterOperatorStatusCondition buildable = new ClusterOperatorStatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterOperatorStatusConditionBuilder that = (ClusterOperatorStatusConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
