package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class LDAPIdentityProviderFluentImpl<A extends LDAPIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LDAPIdentityProviderFluent<A>{

    private LDAPAttributeMappingBuilder attributes;
    private String bindDN;
    private SecretNameReferenceBuilder bindPassword;
    private ConfigMapNameReferenceBuilder ca;
    private Boolean insecure;
    private String url;

    public LDAPIdentityProviderFluentImpl(){
    }
    public LDAPIdentityProviderFluentImpl(LDAPIdentityProvider instance){
            this.withAttributes(instance.getAttributes()); 
            this.withBindDN(instance.getBindDN()); 
            this.withBindPassword(instance.getBindPassword()); 
            this.withCa(instance.getCa()); 
            this.withInsecure(instance.getInsecure()); 
            this.withUrl(instance.getUrl()); 
    }

    
/**
 * This method has been deprecated, please use method buildAttributes instead.
 * @return The buildable object.
 */
@Deprecated public LDAPAttributeMapping getAttributes(){
            return this.attributes!=null?this.attributes.build():null;
    }

    public LDAPAttributeMapping buildAttributes(){
            return this.attributes!=null?this.attributes.build():null;
    }

    public A withAttributes(LDAPAttributeMapping attributes){
            _visitables.get("attributes").remove(this.attributes);
            if (attributes!=null){ this.attributes= new LDAPAttributeMappingBuilder(attributes); _visitables.get("attributes").add(this.attributes);} return (A) this;
    }

    public Boolean hasAttributes(){
            return this.attributes != null;
    }

    public LDAPIdentityProviderFluent.AttributesNested<A> withNewAttributes(){
            return new AttributesNestedImpl();
    }

    public LDAPIdentityProviderFluent.AttributesNested<A> withNewAttributesLike(LDAPAttributeMapping item){
            return new AttributesNestedImpl(item);
    }

    public LDAPIdentityProviderFluent.AttributesNested<A> editAttributes(){
            return withNewAttributesLike(getAttributes());
    }

    public LDAPIdentityProviderFluent.AttributesNested<A> editOrNewAttributes(){
            return withNewAttributesLike(getAttributes() != null ? getAttributes(): new LDAPAttributeMappingBuilder().build());
    }

    public LDAPIdentityProviderFluent.AttributesNested<A> editOrNewAttributesLike(LDAPAttributeMapping item){
            return withNewAttributesLike(getAttributes() != null ? getAttributes(): item);
    }

    public String getBindDN(){
            return this.bindDN;
    }

    public A withBindDN(String bindDN){
            this.bindDN=bindDN; return (A) this;
    }

    public Boolean hasBindDN(){
            return this.bindDN != null;
    }

    public A withNewBindDN(String arg1){
            return (A)withBindDN(new String(arg1));
    }

    public A withNewBindDN(StringBuilder arg1){
            return (A)withBindDN(new String(arg1));
    }

    public A withNewBindDN(StringBuffer arg1){
            return (A)withBindDN(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildBindPassword instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getBindPassword(){
            return this.bindPassword!=null?this.bindPassword.build():null;
    }

    public SecretNameReference buildBindPassword(){
            return this.bindPassword!=null?this.bindPassword.build():null;
    }

    public A withBindPassword(SecretNameReference bindPassword){
            _visitables.get("bindPassword").remove(this.bindPassword);
            if (bindPassword!=null){ this.bindPassword= new SecretNameReferenceBuilder(bindPassword); _visitables.get("bindPassword").add(this.bindPassword);} return (A) this;
    }

    public Boolean hasBindPassword(){
            return this.bindPassword != null;
    }

    public A withNewBindPassword(String name){
            return (A)withBindPassword(new SecretNameReference(name));
    }

    public LDAPIdentityProviderFluent.BindPasswordNested<A> withNewBindPassword(){
            return new BindPasswordNestedImpl();
    }

    public LDAPIdentityProviderFluent.BindPasswordNested<A> withNewBindPasswordLike(SecretNameReference item){
            return new BindPasswordNestedImpl(item);
    }

    public LDAPIdentityProviderFluent.BindPasswordNested<A> editBindPassword(){
            return withNewBindPasswordLike(getBindPassword());
    }

    public LDAPIdentityProviderFluent.BindPasswordNested<A> editOrNewBindPassword(){
            return withNewBindPasswordLike(getBindPassword() != null ? getBindPassword(): new SecretNameReferenceBuilder().build());
    }

    public LDAPIdentityProviderFluent.BindPasswordNested<A> editOrNewBindPasswordLike(SecretNameReference item){
            return withNewBindPasswordLike(getBindPassword() != null ? getBindPassword(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCa instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getCa(){
            return this.ca!=null?this.ca.build():null;
    }

    public ConfigMapNameReference buildCa(){
            return this.ca!=null?this.ca.build():null;
    }

    public A withCa(ConfigMapNameReference ca){
            _visitables.get("ca").remove(this.ca);
            if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public Boolean hasCa(){
            return this.ca != null;
    }

    public A withNewCa(String name){
            return (A)withCa(new ConfigMapNameReference(name));
    }

    public LDAPIdentityProviderFluent.CaNested<A> withNewCa(){
            return new CaNestedImpl();
    }

    public LDAPIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item){
            return new CaNestedImpl(item);
    }

    public LDAPIdentityProviderFluent.CaNested<A> editCa(){
            return withNewCaLike(getCa());
    }

    public LDAPIdentityProviderFluent.CaNested<A> editOrNewCa(){
            return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
    }

    public LDAPIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item){
            return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public Boolean isInsecure(){
            return this.insecure;
    }

    public A withInsecure(Boolean insecure){
            this.insecure=insecure; return (A) this;
    }

    public Boolean hasInsecure(){
            return this.insecure != null;
    }

    public A withNewInsecure(String arg1){
            return (A)withInsecure(new Boolean(arg1));
    }

    public A withNewInsecure(boolean arg1){
            return (A)withInsecure(new Boolean(arg1));
    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LDAPIdentityProviderFluentImpl that = (LDAPIdentityProviderFluentImpl) o;
            if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
            if (bindDN != null ? !bindDN.equals(that.bindDN) :that.bindDN != null) return false;
            if (bindPassword != null ? !bindPassword.equals(that.bindPassword) :that.bindPassword != null) return false;
            if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
            if (insecure != null ? !insecure.equals(that.insecure) :that.insecure != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }


    public class AttributesNestedImpl<N> extends LDAPAttributeMappingFluentImpl<LDAPIdentityProviderFluent.AttributesNested<N>> implements LDAPIdentityProviderFluent.AttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LDAPAttributeMappingBuilder builder;
    
            AttributesNestedImpl(LDAPAttributeMapping item){
                    this.builder = new LDAPAttributeMappingBuilder(this, item);
            }
            AttributesNestedImpl(){
                    this.builder = new LDAPAttributeMappingBuilder(this);
            }
    
    public N and(){
            return (N) LDAPIdentityProviderFluentImpl.this.withAttributes(builder.build());
    }
    public N endAttributes(){
            return and();
    }

}
    public class BindPasswordNestedImpl<N> extends SecretNameReferenceFluentImpl<LDAPIdentityProviderFluent.BindPasswordNested<N>> implements LDAPIdentityProviderFluent.BindPasswordNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretNameReferenceBuilder builder;
    
            BindPasswordNestedImpl(SecretNameReference item){
                    this.builder = new SecretNameReferenceBuilder(this, item);
            }
            BindPasswordNestedImpl(){
                    this.builder = new SecretNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) LDAPIdentityProviderFluentImpl.this.withBindPassword(builder.build());
    }
    public N endBindPassword(){
            return and();
    }

}
    public class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<LDAPIdentityProviderFluent.CaNested<N>> implements LDAPIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigMapNameReferenceBuilder builder;
    
            CaNestedImpl(ConfigMapNameReference item){
                    this.builder = new ConfigMapNameReferenceBuilder(this, item);
            }
            CaNestedImpl(){
                    this.builder = new ConfigMapNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) LDAPIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa(){
            return and();
    }

}


}
