package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyListBuilder extends ProxyListFluentImpl<ProxyListBuilder> implements VisitableBuilder<ProxyList,ProxyListBuilder>{

    ProxyListFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyListBuilder(){
            this(true);
    }
    public ProxyListBuilder(Boolean validationEnabled){
            this(new ProxyList(), validationEnabled);
    }
    public ProxyListBuilder(ProxyListFluent<?> fluent){
            this(fluent, true);
    }
    public ProxyListBuilder(ProxyListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ProxyList(), validationEnabled);
    }
    public ProxyListBuilder(ProxyListFluent<?> fluent,ProxyList instance){
            this(fluent, instance, true);
    }
    public ProxyListBuilder(ProxyListFluent<?> fluent,ProxyList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ProxyListBuilder(ProxyList instance){
            this(instance,true);
    }
    public ProxyListBuilder(ProxyList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ProxyList build(){
            ProxyList buildable = new ProxyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ProxyListBuilder that = (ProxyListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
