package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ReleaseFluent<A extends ReleaseFluent<A>> extends Fluent<A>{


    public A addToChannels(int index,String item);
    public A setToChannels(int index,String item);
    public A addToChannels(String... items);
    public A addAllToChannels(Collection<String> items);
    public A removeFromChannels(String... items);
    public A removeAllFromChannels(Collection<String> items);
    public List<String> getChannels();
    public String getChannel(int index);
    public String getFirstChannel();
    public String getLastChannel();
    public String getMatchingChannel(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingChannel(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withChannels(List<String> channels);
    public A withChannels(String... channels);
    public Boolean hasChannels();
    public A addNewChannel(String arg1);
    public A addNewChannel(StringBuilder arg1);
    public A addNewChannel(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getUrl();
    public A withUrl(String url);
    public Boolean hasUrl();
    public A withNewUrl(String arg1);
    public A withNewUrl(StringBuilder arg1);
    public A withNewUrl(StringBuffer arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);



}
