package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubjectRulesReviewBuilder extends SubjectRulesReviewFluentImpl<SubjectRulesReviewBuilder> implements VisitableBuilder<SubjectRulesReview,SubjectRulesReviewBuilder>{

    SubjectRulesReviewFluent<?> fluent;
    Boolean validationEnabled;

    public SubjectRulesReviewBuilder(){
            this(true);
    }
    public SubjectRulesReviewBuilder(Boolean validationEnabled){
            this(new SubjectRulesReview(), validationEnabled);
    }
    public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent){
            this(fluent, true);
    }
    public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubjectRulesReview(), validationEnabled);
    }
    public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent,SubjectRulesReview instance){
            this(fluent, instance, true);
    }
    public SubjectRulesReviewBuilder(SubjectRulesReviewFluent<?> fluent,SubjectRulesReview instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubjectRulesReviewBuilder(SubjectRulesReview instance){
            this(instance,true);
    }
    public SubjectRulesReviewBuilder(SubjectRulesReview instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubjectRulesReview build(){
            SubjectRulesReview buildable = new SubjectRulesReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubjectRulesReviewBuilder that = (SubjectRulesReviewBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
