package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TLSProfileSpecBuilder extends TLSProfileSpecFluentImpl<TLSProfileSpecBuilder> implements VisitableBuilder<TLSProfileSpec,TLSProfileSpecBuilder>{

    TLSProfileSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TLSProfileSpecBuilder(){
            this(true);
    }
    public TLSProfileSpecBuilder(Boolean validationEnabled){
            this(new TLSProfileSpec(), validationEnabled);
    }
    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent){
            this(fluent, true);
    }
    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TLSProfileSpec(), validationEnabled);
    }
    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent,TLSProfileSpec instance){
            this(fluent, instance, true);
    }
    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent,TLSProfileSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCiphers(instance.getCiphers()); 
            fluent.withMinTLSVersion(instance.getMinTLSVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public TLSProfileSpecBuilder(TLSProfileSpec instance){
            this(instance,true);
    }
    public TLSProfileSpecBuilder(TLSProfileSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCiphers(instance.getCiphers()); 
            this.withMinTLSVersion(instance.getMinTLSVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public TLSProfileSpec build(){
            TLSProfileSpec buildable = new TLSProfileSpec(fluent.getCiphers(),fluent.getMinTLSVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TLSProfileSpecBuilder that = (TLSProfileSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
