
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "custom",
    "intermediate",
    "modern",
    "old",
    "type"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class TLSSecurityProfile implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("custom")
    private CustomTLSProfile custom;
    /**
     * 
     * 
     */
    @JsonProperty("intermediate")
    private IntermediateTLSProfile intermediate;
    /**
     * 
     * 
     */
    @JsonProperty("modern")
    private ModernTLSProfile modern;
    /**
     * 
     * 
     */
    @JsonProperty("old")
    private OldTLSProfile old;
    /**
     * 
     * 
     */
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TLSSecurityProfile() {
    }

    /**
     * 
     * @param modern
     * @param old
     * @param custom
     * @param intermediate
     * @param type
     */
    public TLSSecurityProfile(CustomTLSProfile custom, IntermediateTLSProfile intermediate, ModernTLSProfile modern, OldTLSProfile old, String type) {
        this.custom = custom;
        this.intermediate = intermediate;
        this.modern = modern;
        this.old = old;
        this.type = type;
    }

    /**
     * 
     * 
     * @return
     *     The custom
     */
    @JsonProperty("custom")
    public CustomTLSProfile getCustom() {
        return custom;
    }

    /**
     * 
     * 
     * @param custom
     *     The custom
     */
    @JsonProperty("custom")
    public void setCustom(CustomTLSProfile custom) {
        this.custom = custom;
    }

    /**
     * 
     * 
     * @return
     *     The intermediate
     */
    @JsonProperty("intermediate")
    public IntermediateTLSProfile getIntermediate() {
        return intermediate;
    }

    /**
     * 
     * 
     * @param intermediate
     *     The intermediate
     */
    @JsonProperty("intermediate")
    public void setIntermediate(IntermediateTLSProfile intermediate) {
        this.intermediate = intermediate;
    }

    /**
     * 
     * 
     * @return
     *     The modern
     */
    @JsonProperty("modern")
    public ModernTLSProfile getModern() {
        return modern;
    }

    /**
     * 
     * 
     * @param modern
     *     The modern
     */
    @JsonProperty("modern")
    public void setModern(ModernTLSProfile modern) {
        this.modern = modern;
    }

    /**
     * 
     * 
     * @return
     *     The old
     */
    @JsonProperty("old")
    public OldTLSProfile getOld() {
        return old;
    }

    /**
     * 
     * 
     * @param old
     *     The old
     */
    @JsonProperty("old")
    public void setOld(OldTLSProfile old) {
        this.old = old;
    }

    /**
     * 
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
