package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ClusterVersionStatusFluent<A extends ClusterVersionStatusFluent<A>> extends Fluent<A>{


    public A addToAvailableUpdates(int index,Release item);
    public A setToAvailableUpdates(int index,Release item);
    public A addToAvailableUpdates(Release... items);
    public A addAllToAvailableUpdates(Collection<Release> items);
    public A removeFromAvailableUpdates(Release... items);
    public A removeAllFromAvailableUpdates(Collection<Release> items);
    public A removeMatchingFromAvailableUpdates(io.fabric8.kubernetes.api.builder.Predicate<ReleaseBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAvailableUpdates instead.
 * @return The buildable object.
 */
@Deprecated public List<Release> getAvailableUpdates();
    public List<Release> buildAvailableUpdates();
    public Release buildAvailableUpdate(int index);
    public Release buildFirstAvailableUpdate();
    public Release buildLastAvailableUpdate();
    public Release buildMatchingAvailableUpdate(io.fabric8.kubernetes.api.builder.Predicate<ReleaseBuilder> predicate);
    public Boolean hasMatchingAvailableUpdate(io.fabric8.kubernetes.api.builder.Predicate<ReleaseBuilder> predicate);
    public A withAvailableUpdates(List<Release> availableUpdates);
    public A withAvailableUpdates(Release... availableUpdates);
    public Boolean hasAvailableUpdates();
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdate();
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item);
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> setNewAvailableUpdateLike(int index,Release item);
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editAvailableUpdate(int index);
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editFirstAvailableUpdate();
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editLastAvailableUpdate();
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editMatchingAvailableUpdate(io.fabric8.kubernetes.api.builder.Predicate<ReleaseBuilder> predicate);
    public A addToConditions(int index,ClusterOperatorStatusCondition item);
    public A setToConditions(int index,ClusterOperatorStatusCondition item);
    public A addToConditions(ClusterOperatorStatusCondition... items);
    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeFromConditions(ClusterOperatorStatusCondition... items);
    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterOperatorStatusCondition> getConditions();
    public List<ClusterOperatorStatusCondition> buildConditions();
    public ClusterOperatorStatusCondition buildCondition(int index);
    public ClusterOperatorStatusCondition buildFirstCondition();
    public ClusterOperatorStatusCondition buildLastCondition();
    public ClusterOperatorStatusCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public A withConditions(List<ClusterOperatorStatusCondition> conditions);
    public A withConditions(ClusterOperatorStatusCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public ClusterVersionStatusFluent.ConditionsNested<A> addNewCondition();
    public ClusterVersionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item);
    public ClusterVersionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item);
    public ClusterVersionStatusFluent.ConditionsNested<A> editCondition(int index);
    public ClusterVersionStatusFluent.ConditionsNested<A> editFirstCondition();
    public ClusterVersionStatusFluent.ConditionsNested<A> editLastCondition();
    public ClusterVersionStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDesired instead.
 * @return The buildable object.
 */
@Deprecated public Release getDesired();
    public Release buildDesired();
    public A withDesired(Release desired);
    public Boolean hasDesired();
    public ClusterVersionStatusFluent.DesiredNested<A> withNewDesired();
    public ClusterVersionStatusFluent.DesiredNested<A> withNewDesiredLike(Release item);
    public ClusterVersionStatusFluent.DesiredNested<A> editDesired();
    public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesired();
    public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesiredLike(Release item);
    public A addToHistory(int index,UpdateHistory item);
    public A setToHistory(int index,UpdateHistory item);
    public A addToHistory(UpdateHistory... items);
    public A addAllToHistory(Collection<UpdateHistory> items);
    public A removeFromHistory(UpdateHistory... items);
    public A removeAllFromHistory(Collection<UpdateHistory> items);
    public A removeMatchingFromHistory(io.fabric8.kubernetes.api.builder.Predicate<UpdateHistoryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildHistory instead.
 * @return The buildable object.
 */
@Deprecated public List<UpdateHistory> getHistory();
    public List<UpdateHistory> buildHistory();
    public UpdateHistory buildHistory(int index);
    public UpdateHistory buildFirstHistory();
    public UpdateHistory buildLastHistory();
    public UpdateHistory buildMatchingHistory(io.fabric8.kubernetes.api.builder.Predicate<UpdateHistoryBuilder> predicate);
    public Boolean hasMatchingHistory(io.fabric8.kubernetes.api.builder.Predicate<UpdateHistoryBuilder> predicate);
    public A withHistory(List<UpdateHistory> history);
    public A withHistory(UpdateHistory... history);
    public Boolean hasHistory();
    public ClusterVersionStatusFluent.HistoryNested<A> addNewHistory();
    public ClusterVersionStatusFluent.HistoryNested<A> addNewHistoryLike(UpdateHistory item);
    public ClusterVersionStatusFluent.HistoryNested<A> setNewHistoryLike(int index,UpdateHistory item);
    public ClusterVersionStatusFluent.HistoryNested<A> editHistory(int index);
    public ClusterVersionStatusFluent.HistoryNested<A> editFirstHistory();
    public ClusterVersionStatusFluent.HistoryNested<A> editLastHistory();
    public ClusterVersionStatusFluent.HistoryNested<A> editMatchingHistory(io.fabric8.kubernetes.api.builder.Predicate<UpdateHistoryBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public String getVersionHash();
    public A withVersionHash(String versionHash);
    public Boolean hasVersionHash();
    public A withNewVersionHash(String arg1);
    public A withNewVersionHash(StringBuilder arg1);
    public A withNewVersionHash(StringBuffer arg1);

    public interface AvailableUpdatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReleaseFluent<ClusterVersionStatusFluent.AvailableUpdatesNested<N>>{

        
    public N and();    public N endAvailableUpdate();
}
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorStatusConditionFluent<ClusterVersionStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface DesiredNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReleaseFluent<ClusterVersionStatusFluent.DesiredNested<N>>{

        
    public N and();    public N endDesired();
}
    public interface HistoryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UpdateHistoryFluent<ClusterVersionStatusFluent.HistoryNested<N>>{

        
    public N and();    public N endHistory();
}


}
