package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IBMCloudPlatformSpecBuilder extends IBMCloudPlatformSpecFluentImpl<IBMCloudPlatformSpecBuilder> implements VisitableBuilder<IBMCloudPlatformSpec,IBMCloudPlatformSpecBuilder>{

    IBMCloudPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IBMCloudPlatformSpecBuilder(){
            this(true);
    }
    public IBMCloudPlatformSpecBuilder(Boolean validationEnabled){
            this(new IBMCloudPlatformSpec(), validationEnabled);
    }
    public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent){
            this(fluent, true);
    }
    public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IBMCloudPlatformSpec(), validationEnabled);
    }
    public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent,IBMCloudPlatformSpec instance){
            this(fluent, instance, true);
    }
    public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent,IBMCloudPlatformSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpec instance){
            this(instance,true);
    }
    public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public IBMCloudPlatformSpec build(){
            IBMCloudPlatformSpec buildable = new IBMCloudPlatformSpec();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IBMCloudPlatformSpecBuilder that = (IBMCloudPlatformSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
