package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IBMCloudPlatformStatusFluentImpl<A extends IBMCloudPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IBMCloudPlatformStatusFluent<A>{

    private String location;
    private String providerType;
    private String resourceGroupName;

    public IBMCloudPlatformStatusFluentImpl(){
    }
    public IBMCloudPlatformStatusFluentImpl(IBMCloudPlatformStatus instance){
            this.withLocation(instance.getLocation()); 
            this.withProviderType(instance.getProviderType()); 
            this.withResourceGroupName(instance.getResourceGroupName()); 
    }

    public String getLocation(){
            return this.location;
    }

    public A withLocation(String location){
            this.location=location; return (A) this;
    }

    public Boolean hasLocation(){
            return this.location != null;
    }

    public A withNewLocation(String arg1){
            return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(StringBuilder arg1){
            return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(StringBuffer arg1){
            return (A)withLocation(new String(arg1));
    }

    public String getProviderType(){
            return this.providerType;
    }

    public A withProviderType(String providerType){
            this.providerType=providerType; return (A) this;
    }

    public Boolean hasProviderType(){
            return this.providerType != null;
    }

    public A withNewProviderType(String arg1){
            return (A)withProviderType(new String(arg1));
    }

    public A withNewProviderType(StringBuilder arg1){
            return (A)withProviderType(new String(arg1));
    }

    public A withNewProviderType(StringBuffer arg1){
            return (A)withProviderType(new String(arg1));
    }

    public String getResourceGroupName(){
            return this.resourceGroupName;
    }

    public A withResourceGroupName(String resourceGroupName){
            this.resourceGroupName=resourceGroupName; return (A) this;
    }

    public Boolean hasResourceGroupName(){
            return this.resourceGroupName != null;
    }

    public A withNewResourceGroupName(String arg1){
            return (A)withResourceGroupName(new String(arg1));
    }

    public A withNewResourceGroupName(StringBuilder arg1){
            return (A)withResourceGroupName(new String(arg1));
    }

    public A withNewResourceGroupName(StringBuffer arg1){
            return (A)withResourceGroupName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            IBMCloudPlatformStatusFluentImpl that = (IBMCloudPlatformStatusFluentImpl) o;
            if (location != null ? !location.equals(that.location) :that.location != null) return false;
            if (providerType != null ? !providerType.equals(that.providerType) :that.providerType != null) return false;
            if (resourceGroupName != null ? !resourceGroupName.equals(that.resourceGroupName) :that.resourceGroupName != null) return false;
            return true;
    }




}
