package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamMappingBuilder extends ImageStreamMappingFluentImpl<ImageStreamMappingBuilder> implements VisitableBuilder<ImageStreamMapping,ImageStreamMappingBuilder>{

    ImageStreamMappingFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamMappingBuilder(){
            this(true);
    }
    public ImageStreamMappingBuilder(Boolean validationEnabled){
            this(new ImageStreamMapping(), validationEnabled);
    }
    public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent){
            this(fluent, true);
    }
    public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageStreamMapping(), validationEnabled);
    }
    public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent,ImageStreamMapping instance){
            this(fluent, instance, true);
    }
    public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent,ImageStreamMapping instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withImage(instance.getImage()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withTag(instance.getTag()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageStreamMappingBuilder(ImageStreamMapping instance){
            this(instance,true);
    }
    public ImageStreamMappingBuilder(ImageStreamMapping instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withImage(instance.getImage()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withTag(instance.getTag()); 
            this.validationEnabled = validationEnabled; 
    }

    public ImageStreamMapping build(){
            ImageStreamMapping buildable = new ImageStreamMapping(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata(),fluent.getTag());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamMappingBuilder that = (ImageStreamMappingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
