package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorHubListBuilder extends OperatorHubListFluentImpl<OperatorHubListBuilder> implements VisitableBuilder<OperatorHubList,OperatorHubListBuilder>{

    OperatorHubListFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorHubListBuilder(){
            this(true);
    }
    public OperatorHubListBuilder(Boolean validationEnabled){
            this(new OperatorHubList(), validationEnabled);
    }
    public OperatorHubListBuilder(OperatorHubListFluent<?> fluent){
            this(fluent, true);
    }
    public OperatorHubListBuilder(OperatorHubListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OperatorHubList(), validationEnabled);
    }
    public OperatorHubListBuilder(OperatorHubListFluent<?> fluent,OperatorHubList instance){
            this(fluent, instance, true);
    }
    public OperatorHubListBuilder(OperatorHubListFluent<?> fluent,OperatorHubList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public OperatorHubListBuilder(OperatorHubList instance){
            this(instance,true);
    }
    public OperatorHubListBuilder(OperatorHubList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public OperatorHubList build(){
            OperatorHubList buildable = new OperatorHubList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OperatorHubListBuilder that = (OperatorHubListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
