package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface SchedulerFluent<A extends SchedulerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public SchedulerFluent.MetadataNested<A> withNewMetadata();
    public SchedulerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public SchedulerFluent.MetadataNested<A> editMetadata();
    public SchedulerFluent.MetadataNested<A> editOrNewMetadata();
    public SchedulerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getSpec();
    public SchedulerSpec buildSpec();
    public A withSpec(SchedulerSpec spec);
    public Boolean hasSpec();
    public SchedulerFluent.SpecNested<A> withNewSpec();
    public SchedulerFluent.SpecNested<A> withNewSpecLike(SchedulerSpec item);
    public SchedulerFluent.SpecNested<A> editSpec();
    public SchedulerFluent.SpecNested<A> editOrNewSpec();
    public SchedulerFluent.SpecNested<A> editOrNewSpecLike(SchedulerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerStatus getStatus();
    public SchedulerStatus buildStatus();
    public A withStatus(SchedulerStatus status);
    public Boolean hasStatus();
    public SchedulerFluent.StatusNested<A> withNewStatus();
    public SchedulerFluent.StatusNested<A> withNewStatusLike(SchedulerStatus item);
    public SchedulerFluent.StatusNested<A> editStatus();
    public SchedulerFluent.StatusNested<A> editOrNewStatus();
    public SchedulerFluent.StatusNested<A> editOrNewStatusLike(SchedulerStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<SchedulerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerSpecFluent<SchedulerFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerStatusFluent<SchedulerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
