package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class APIServerSpecFluentImpl<A extends APIServerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServerSpecFluent<A>{

    private List<String> additionalCORSAllowedOrigins = new ArrayList<String>();
    private AuditBuilder audit;
    private ConfigMapNameReferenceBuilder clientCA;
    private APIServerEncryptionBuilder encryption;
    private APIServerServingCertsBuilder servingCerts;
    private TLSSecurityProfileBuilder tlsSecurityProfile;

    public APIServerSpecFluentImpl(){
    }
    public APIServerSpecFluentImpl(APIServerSpec instance){
            this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
            this.withAudit(instance.getAudit()); 
            this.withClientCA(instance.getClientCA()); 
            this.withEncryption(instance.getEncryption()); 
            this.withServingCerts(instance.getServingCerts()); 
            this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    }

    public A addToAdditionalCORSAllowedOrigins(int index,String item){
            if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
            this.additionalCORSAllowedOrigins.add(index, item);
            return (A)this;
    }

    public A setToAdditionalCORSAllowedOrigins(int index,String item){
            if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
            this.additionalCORSAllowedOrigins.set(index, item); return (A)this;
    }

    public A addToAdditionalCORSAllowedOrigins(String... items){
            if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
            for (String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
    }

    public A addAllToAdditionalCORSAllowedOrigins(Collection<String> items){
            if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
            for (String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
    }

    public A removeFromAdditionalCORSAllowedOrigins(String... items){
            for (String item : items) {if (this.additionalCORSAllowedOrigins!= null){ this.additionalCORSAllowedOrigins.remove(item);}} return (A)this;
    }

    public A removeAllFromAdditionalCORSAllowedOrigins(Collection<String> items){
            for (String item : items) {if (this.additionalCORSAllowedOrigins!= null){ this.additionalCORSAllowedOrigins.remove(item);}} return (A)this;
    }

    public List<String> getAdditionalCORSAllowedOrigins(){
            return this.additionalCORSAllowedOrigins;
    }

    public String getAdditionalCORSAllowedOrigin(int index){
            return this.additionalCORSAllowedOrigins.get(index);
    }

    public String getFirstAdditionalCORSAllowedOrigin(){
            return this.additionalCORSAllowedOrigins.get(0);
    }

    public String getLastAdditionalCORSAllowedOrigin(){
            return this.additionalCORSAllowedOrigins.get(additionalCORSAllowedOrigins.size() - 1);
    }

    public String getMatchingAdditionalCORSAllowedOrigin(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: additionalCORSAllowedOrigins) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAdditionalCORSAllowedOrigin(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: additionalCORSAllowedOrigins) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAdditionalCORSAllowedOrigins(List<String> additionalCORSAllowedOrigins){
            if (this.additionalCORSAllowedOrigins != null) { _visitables.get("additionalCORSAllowedOrigins").removeAll(this.additionalCORSAllowedOrigins);}
            if (additionalCORSAllowedOrigins != null) {this.additionalCORSAllowedOrigins = new ArrayList<String>(); for (String item : additionalCORSAllowedOrigins){this.addToAdditionalCORSAllowedOrigins(item);}} else { this.additionalCORSAllowedOrigins = null;} return (A) this;
    }

    public A withAdditionalCORSAllowedOrigins(String... additionalCORSAllowedOrigins){
            if (this.additionalCORSAllowedOrigins != null) {this.additionalCORSAllowedOrigins.clear();}
            if (additionalCORSAllowedOrigins != null) {for (String item :additionalCORSAllowedOrigins){ this.addToAdditionalCORSAllowedOrigins(item);}} return (A) this;
    }

    public Boolean hasAdditionalCORSAllowedOrigins(){
            return additionalCORSAllowedOrigins != null && !additionalCORSAllowedOrigins.isEmpty();
    }

    public A addNewAdditionalCORSAllowedOrigin(String arg1){
            return (A)addToAdditionalCORSAllowedOrigins(new String(arg1));
    }

    public A addNewAdditionalCORSAllowedOrigin(StringBuilder arg1){
            return (A)addToAdditionalCORSAllowedOrigins(new String(arg1));
    }

    public A addNewAdditionalCORSAllowedOrigin(StringBuffer arg1){
            return (A)addToAdditionalCORSAllowedOrigins(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildAudit instead.
 * @return The buildable object.
 */
@Deprecated public Audit getAudit(){
            return this.audit!=null?this.audit.build():null;
    }

    public Audit buildAudit(){
            return this.audit!=null?this.audit.build():null;
    }

    public A withAudit(Audit audit){
            _visitables.get("audit").remove(this.audit);
            if (audit!=null){ this.audit= new AuditBuilder(audit); _visitables.get("audit").add(this.audit);} return (A) this;
    }

    public Boolean hasAudit(){
            return this.audit != null;
    }

    public A withNewAudit(String profile){
            return (A)withAudit(new Audit(profile));
    }

    public APIServerSpecFluent.AuditNested<A> withNewAudit(){
            return new AuditNestedImpl();
    }

    public APIServerSpecFluent.AuditNested<A> withNewAuditLike(Audit item){
            return new AuditNestedImpl(item);
    }

    public APIServerSpecFluent.AuditNested<A> editAudit(){
            return withNewAuditLike(getAudit());
    }

    public APIServerSpecFluent.AuditNested<A> editOrNewAudit(){
            return withNewAuditLike(getAudit() != null ? getAudit(): new AuditBuilder().build());
    }

    public APIServerSpecFluent.AuditNested<A> editOrNewAuditLike(Audit item){
            return withNewAuditLike(getAudit() != null ? getAudit(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClientCA instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getClientCA(){
            return this.clientCA!=null?this.clientCA.build():null;
    }

    public ConfigMapNameReference buildClientCA(){
            return this.clientCA!=null?this.clientCA.build():null;
    }

    public A withClientCA(ConfigMapNameReference clientCA){
            _visitables.get("clientCA").remove(this.clientCA);
            if (clientCA!=null){ this.clientCA= new ConfigMapNameReferenceBuilder(clientCA); _visitables.get("clientCA").add(this.clientCA);} return (A) this;
    }

    public Boolean hasClientCA(){
            return this.clientCA != null;
    }

    public A withNewClientCA(String name){
            return (A)withClientCA(new ConfigMapNameReference(name));
    }

    public APIServerSpecFluent.ClientCANested<A> withNewClientCA(){
            return new ClientCANestedImpl();
    }

    public APIServerSpecFluent.ClientCANested<A> withNewClientCALike(ConfigMapNameReference item){
            return new ClientCANestedImpl(item);
    }

    public APIServerSpecFluent.ClientCANested<A> editClientCA(){
            return withNewClientCALike(getClientCA());
    }

    public APIServerSpecFluent.ClientCANested<A> editOrNewClientCA(){
            return withNewClientCALike(getClientCA() != null ? getClientCA(): new ConfigMapNameReferenceBuilder().build());
    }

    public APIServerSpecFluent.ClientCANested<A> editOrNewClientCALike(ConfigMapNameReference item){
            return withNewClientCALike(getClientCA() != null ? getClientCA(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEncryption instead.
 * @return The buildable object.
 */
@Deprecated public APIServerEncryption getEncryption(){
            return this.encryption!=null?this.encryption.build():null;
    }

    public APIServerEncryption buildEncryption(){
            return this.encryption!=null?this.encryption.build():null;
    }

    public A withEncryption(APIServerEncryption encryption){
            _visitables.get("encryption").remove(this.encryption);
            if (encryption!=null){ this.encryption= new APIServerEncryptionBuilder(encryption); _visitables.get("encryption").add(this.encryption);} return (A) this;
    }

    public Boolean hasEncryption(){
            return this.encryption != null;
    }

    public A withNewEncryption(String type){
            return (A)withEncryption(new APIServerEncryption(type));
    }

    public APIServerSpecFluent.EncryptionNested<A> withNewEncryption(){
            return new EncryptionNestedImpl();
    }

    public APIServerSpecFluent.EncryptionNested<A> withNewEncryptionLike(APIServerEncryption item){
            return new EncryptionNestedImpl(item);
    }

    public APIServerSpecFluent.EncryptionNested<A> editEncryption(){
            return withNewEncryptionLike(getEncryption());
    }

    public APIServerSpecFluent.EncryptionNested<A> editOrNewEncryption(){
            return withNewEncryptionLike(getEncryption() != null ? getEncryption(): new APIServerEncryptionBuilder().build());
    }

    public APIServerSpecFluent.EncryptionNested<A> editOrNewEncryptionLike(APIServerEncryption item){
            return withNewEncryptionLike(getEncryption() != null ? getEncryption(): item);
    }

    
/**
 * This method has been deprecated, please use method buildServingCerts instead.
 * @return The buildable object.
 */
@Deprecated public APIServerServingCerts getServingCerts(){
            return this.servingCerts!=null?this.servingCerts.build():null;
    }

    public APIServerServingCerts buildServingCerts(){
            return this.servingCerts!=null?this.servingCerts.build():null;
    }

    public A withServingCerts(APIServerServingCerts servingCerts){
            _visitables.get("servingCerts").remove(this.servingCerts);
            if (servingCerts!=null){ this.servingCerts= new APIServerServingCertsBuilder(servingCerts); _visitables.get("servingCerts").add(this.servingCerts);} return (A) this;
    }

    public Boolean hasServingCerts(){
            return this.servingCerts != null;
    }

    public APIServerSpecFluent.ServingCertsNested<A> withNewServingCerts(){
            return new ServingCertsNestedImpl();
    }

    public APIServerSpecFluent.ServingCertsNested<A> withNewServingCertsLike(APIServerServingCerts item){
            return new ServingCertsNestedImpl(item);
    }

    public APIServerSpecFluent.ServingCertsNested<A> editServingCerts(){
            return withNewServingCertsLike(getServingCerts());
    }

    public APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCerts(){
            return withNewServingCertsLike(getServingCerts() != null ? getServingCerts(): new APIServerServingCertsBuilder().build());
    }

    public APIServerSpecFluent.ServingCertsNested<A> editOrNewServingCertsLike(APIServerServingCerts item){
            return withNewServingCertsLike(getServingCerts() != null ? getServingCerts(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSecurityProfile instead.
 * @return The buildable object.
 */
@Deprecated public TLSSecurityProfile getTlsSecurityProfile(){
            return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public TLSSecurityProfile buildTlsSecurityProfile(){
            return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile){
            _visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile);
            if (tlsSecurityProfile!=null){ this.tlsSecurityProfile= new TLSSecurityProfileBuilder(tlsSecurityProfile); _visitables.get("tlsSecurityProfile").add(this.tlsSecurityProfile);} return (A) this;
    }

    public Boolean hasTlsSecurityProfile(){
            return this.tlsSecurityProfile != null;
    }

    public APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfile(){
            return new TlsSecurityProfileNestedImpl();
    }

    public APIServerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(TLSSecurityProfile item){
            return new TlsSecurityProfileNestedImpl(item);
    }

    public APIServerSpecFluent.TlsSecurityProfileNested<A> editTlsSecurityProfile(){
            return withNewTlsSecurityProfileLike(getTlsSecurityProfile());
    }

    public APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile(){
            return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): new TLSSecurityProfileBuilder().build());
    }

    public APIServerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(TLSSecurityProfile item){
            return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            APIServerSpecFluentImpl that = (APIServerSpecFluentImpl) o;
            if (additionalCORSAllowedOrigins != null ? !additionalCORSAllowedOrigins.equals(that.additionalCORSAllowedOrigins) :that.additionalCORSAllowedOrigins != null) return false;
            if (audit != null ? !audit.equals(that.audit) :that.audit != null) return false;
            if (clientCA != null ? !clientCA.equals(that.clientCA) :that.clientCA != null) return false;
            if (encryption != null ? !encryption.equals(that.encryption) :that.encryption != null) return false;
            if (servingCerts != null ? !servingCerts.equals(that.servingCerts) :that.servingCerts != null) return false;
            if (tlsSecurityProfile != null ? !tlsSecurityProfile.equals(that.tlsSecurityProfile) :that.tlsSecurityProfile != null) return false;
            return true;
    }


    public class AuditNestedImpl<N> extends AuditFluentImpl<APIServerSpecFluent.AuditNested<N>> implements APIServerSpecFluent.AuditNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AuditBuilder builder;
    
            AuditNestedImpl(Audit item){
                    this.builder = new AuditBuilder(this, item);
            }
            AuditNestedImpl(){
                    this.builder = new AuditBuilder(this);
            }
    
    public N and(){
            return (N) APIServerSpecFluentImpl.this.withAudit(builder.build());
    }
    public N endAudit(){
            return and();
    }

}
    public class ClientCANestedImpl<N> extends ConfigMapNameReferenceFluentImpl<APIServerSpecFluent.ClientCANested<N>> implements APIServerSpecFluent.ClientCANested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigMapNameReferenceBuilder builder;
    
            ClientCANestedImpl(ConfigMapNameReference item){
                    this.builder = new ConfigMapNameReferenceBuilder(this, item);
            }
            ClientCANestedImpl(){
                    this.builder = new ConfigMapNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) APIServerSpecFluentImpl.this.withClientCA(builder.build());
    }
    public N endClientCA(){
            return and();
    }

}
    public class EncryptionNestedImpl<N> extends APIServerEncryptionFluentImpl<APIServerSpecFluent.EncryptionNested<N>> implements APIServerSpecFluent.EncryptionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final APIServerEncryptionBuilder builder;
    
            EncryptionNestedImpl(APIServerEncryption item){
                    this.builder = new APIServerEncryptionBuilder(this, item);
            }
            EncryptionNestedImpl(){
                    this.builder = new APIServerEncryptionBuilder(this);
            }
    
    public N and(){
            return (N) APIServerSpecFluentImpl.this.withEncryption(builder.build());
    }
    public N endEncryption(){
            return and();
    }

}
    public class ServingCertsNestedImpl<N> extends APIServerServingCertsFluentImpl<APIServerSpecFluent.ServingCertsNested<N>> implements APIServerSpecFluent.ServingCertsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final APIServerServingCertsBuilder builder;
    
            ServingCertsNestedImpl(APIServerServingCerts item){
                    this.builder = new APIServerServingCertsBuilder(this, item);
            }
            ServingCertsNestedImpl(){
                    this.builder = new APIServerServingCertsBuilder(this);
            }
    
    public N and(){
            return (N) APIServerSpecFluentImpl.this.withServingCerts(builder.build());
    }
    public N endServingCerts(){
            return and();
    }

}
    public class TlsSecurityProfileNestedImpl<N> extends TLSSecurityProfileFluentImpl<APIServerSpecFluent.TlsSecurityProfileNested<N>> implements APIServerSpecFluent.TlsSecurityProfileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TLSSecurityProfileBuilder builder;
    
            TlsSecurityProfileNestedImpl(TLSSecurityProfile item){
                    this.builder = new TLSSecurityProfileBuilder(this, item);
            }
            TlsSecurityProfileNestedImpl(){
                    this.builder = new TLSSecurityProfileBuilder(this);
            }
    
    public N and(){
            return (N) APIServerSpecFluentImpl.this.withTlsSecurityProfile(builder.build());
    }
    public N endTlsSecurityProfile(){
            return and();
    }

}


}
