package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface AWSPlatformStatusFluent<A extends AWSPlatformStatusFluent<A>> extends Fluent<A>{


    public String getRegion();
    public A withRegion(String region);
    public Boolean hasRegion();
    public A withNewRegion(String arg1);
    public A withNewRegion(StringBuilder arg1);
    public A withNewRegion(StringBuffer arg1);
    public A addToServiceEndpoints(int index,AWSServiceEndpoint item);
    public A setToServiceEndpoints(int index,AWSServiceEndpoint item);
    public A addToServiceEndpoints(AWSServiceEndpoint... items);
    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items);
    public A removeFromServiceEndpoints(AWSServiceEndpoint... items);
    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items);
    public A removeMatchingFromServiceEndpoints(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServiceEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<AWSServiceEndpoint> getServiceEndpoints();
    public List<AWSServiceEndpoint> buildServiceEndpoints();
    public AWSServiceEndpoint buildServiceEndpoint(int index);
    public AWSServiceEndpoint buildFirstServiceEndpoint();
    public AWSServiceEndpoint buildLastServiceEndpoint();
    public AWSServiceEndpoint buildMatchingServiceEndpoint(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate);
    public Boolean hasMatchingServiceEndpoint(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate);
    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints);
    public A withServiceEndpoints(AWSServiceEndpoint... serviceEndpoints);
    public Boolean hasServiceEndpoints();
    public A addNewServiceEndpoint(String name,String url);
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint();
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item);
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item);
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(int index);
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint();
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint();
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate);

    public interface ServiceEndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AWSServiceEndpointFluent<AWSPlatformStatusFluent.ServiceEndpointsNested<N>>{

        
    public N and();    public N endServiceEndpoint();
}


}
