package io.fabric8.openshift.api.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ClusterNetworkEntryFluentImpl<A extends ClusterNetworkEntryFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterNetworkEntryFluent<A>{

    private String cIDR;
    private Integer hostSubnetLength;

    public ClusterNetworkEntryFluentImpl(){
    }
    public ClusterNetworkEntryFluentImpl(ClusterNetworkEntry instance){
            this.withCIDR(instance.getCIDR()); 
            this.withHostSubnetLength(instance.getHostSubnetLength()); 
    }

    public String getCIDR(){
            return this.cIDR;
    }

    public A withCIDR(String cIDR){
            this.cIDR=cIDR; return (A) this;
    }

    public Boolean hasCIDR(){
            return this.cIDR != null;
    }

    public A withNewCIDR(String arg1){
            return (A)withCIDR(new String(arg1));
    }

    public A withNewCIDR(StringBuilder arg1){
            return (A)withCIDR(new String(arg1));
    }

    public A withNewCIDR(StringBuffer arg1){
            return (A)withCIDR(new String(arg1));
    }

    public Integer getHostSubnetLength(){
            return this.hostSubnetLength;
    }

    public A withHostSubnetLength(Integer hostSubnetLength){
            this.hostSubnetLength=hostSubnetLength; return (A) this;
    }

    public Boolean hasHostSubnetLength(){
            return this.hostSubnetLength != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ClusterNetworkEntryFluentImpl that = (ClusterNetworkEntryFluentImpl) o;
            if (cIDR != null ? !cIDR.equals(that.cIDR) :that.cIDR != null) return false;
            if (hostSubnetLength != null ? !hostSubnetLength.equals(that.hostSubnetLength) :that.hostSubnetLength != null) return false;
            return true;
    }




}
