package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterResourceQuotaFluent<A extends ClusterResourceQuotaFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ClusterResourceQuotaFluent.MetadataNested<A> withNewMetadata();
    public ClusterResourceQuotaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterResourceQuotaFluent.MetadataNested<A> editMetadata();
    public ClusterResourceQuotaFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterResourceQuotaFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ClusterResourceQuotaSpec getSpec();
    public ClusterResourceQuotaSpec buildSpec();
    public A withSpec(ClusterResourceQuotaSpec spec);
    public Boolean hasSpec();
    public ClusterResourceQuotaFluent.SpecNested<A> withNewSpec();
    public ClusterResourceQuotaFluent.SpecNested<A> withNewSpecLike(ClusterResourceQuotaSpec item);
    public ClusterResourceQuotaFluent.SpecNested<A> editSpec();
    public ClusterResourceQuotaFluent.SpecNested<A> editOrNewSpec();
    public ClusterResourceQuotaFluent.SpecNested<A> editOrNewSpecLike(ClusterResourceQuotaSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ClusterResourceQuotaStatus getStatus();
    public ClusterResourceQuotaStatus buildStatus();
    public A withStatus(ClusterResourceQuotaStatus status);
    public Boolean hasStatus();
    public ClusterResourceQuotaFluent.StatusNested<A> withNewStatus();
    public ClusterResourceQuotaFluent.StatusNested<A> withNewStatusLike(ClusterResourceQuotaStatus item);
    public ClusterResourceQuotaFluent.StatusNested<A> editStatus();
    public ClusterResourceQuotaFluent.StatusNested<A> editOrNewStatus();
    public ClusterResourceQuotaFluent.StatusNested<A> editOrNewStatusLike(ClusterResourceQuotaStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterResourceQuotaFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaSpecFluent<ClusterResourceQuotaFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaStatusFluent<ClusterResourceQuotaFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
