package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaSpecFluentImpl<A extends ClusterResourceQuotaSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterResourceQuotaSpecFluent<A>{

    private ResourceQuotaSpec quota;
    private ClusterResourceQuotaSelectorBuilder selector;

    public ClusterResourceQuotaSpecFluentImpl(){
    }
    public ClusterResourceQuotaSpecFluentImpl(ClusterResourceQuotaSpec instance){
            this.withQuota(instance.getQuota()); 
            this.withSelector(instance.getSelector()); 
    }

    public ResourceQuotaSpec getQuota(){
            return this.quota;
    }

    public A withQuota(ResourceQuotaSpec quota){
            this.quota=quota; return (A) this;
    }

    public Boolean hasQuota(){
            return this.quota != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public ClusterResourceQuotaSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public ClusterResourceQuotaSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(ClusterResourceQuotaSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new ClusterResourceQuotaSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public ClusterResourceQuotaSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public ClusterResourceQuotaSpecFluent.SelectorNested<A> withNewSelectorLike(ClusterResourceQuotaSelector item){
            return new SelectorNestedImpl(item);
    }

    public ClusterResourceQuotaSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public ClusterResourceQuotaSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new ClusterResourceQuotaSelectorBuilder().build());
    }

    public ClusterResourceQuotaSpecFluent.SelectorNested<A> editOrNewSelectorLike(ClusterResourceQuotaSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ClusterResourceQuotaSpecFluentImpl that = (ClusterResourceQuotaSpecFluentImpl) o;
            if (quota != null ? !quota.equals(that.quota) :that.quota != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends ClusterResourceQuotaSelectorFluentImpl<ClusterResourceQuotaSpecFluent.SelectorNested<N>> implements ClusterResourceQuotaSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterResourceQuotaSelectorBuilder builder;
    
            SelectorNestedImpl(ClusterResourceQuotaSelector item){
                    this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new ClusterResourceQuotaSelectorBuilder(this);
            }
    
    public N and(){
            return (N) ClusterResourceQuotaSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}


}
