package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FeatureGateBuilder extends FeatureGateFluentImpl<FeatureGateBuilder> implements VisitableBuilder<FeatureGate,FeatureGateBuilder>{

    FeatureGateFluent<?> fluent;
    Boolean validationEnabled;

    public FeatureGateBuilder(){
            this(true);
    }
    public FeatureGateBuilder(Boolean validationEnabled){
            this(new FeatureGate(), validationEnabled);
    }
    public FeatureGateBuilder(FeatureGateFluent<?> fluent){
            this(fluent, true);
    }
    public FeatureGateBuilder(FeatureGateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new FeatureGate(), validationEnabled);
    }
    public FeatureGateBuilder(FeatureGateFluent<?> fluent,FeatureGate instance){
            this(fluent, instance, true);
    }
    public FeatureGateBuilder(FeatureGateFluent<?> fluent,FeatureGate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public FeatureGateBuilder(FeatureGate instance){
            this(instance,true);
    }
    public FeatureGateBuilder(FeatureGate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public FeatureGate build(){
            FeatureGate buildable = new FeatureGate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FeatureGateBuilder that = (FeatureGateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
