package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface GoogleIdentityProviderFluent<A extends GoogleIdentityProviderFluent<A>> extends Fluent<A>{


    public String getClientID();
    public A withClientID(String clientID);
    public Boolean hasClientID();
    public A withNewClientID(String arg1);
    public A withNewClientID(StringBuilder arg1);
    public A withNewClientID(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getClientSecret();
    public SecretNameReference buildClientSecret();
    public A withClientSecret(SecretNameReference clientSecret);
    public Boolean hasClientSecret();
    public A withNewClientSecret(String name);
    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret();
    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item);
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editClientSecret();
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret();
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item);
    public String getHostedDomain();
    public A withHostedDomain(String hostedDomain);
    public Boolean hasHostedDomain();
    public A withNewHostedDomain(String arg1);
    public A withNewHostedDomain(StringBuilder arg1);
    public A withNewHostedDomain(StringBuffer arg1);

    public interface ClientSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretNameReferenceFluent<GoogleIdentityProviderFluent.ClientSecretNested<N>>{

        
    public N and();    public N endClientSecret();
}


}
