package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface OAuthFluent<A extends OAuthFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public OAuthFluent.MetadataNested<A> withNewMetadata();
    public OAuthFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthFluent.MetadataNested<A> editMetadata();
    public OAuthFluent.MetadataNested<A> editOrNewMetadata();
    public OAuthFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public OAuthSpec getSpec();
    public OAuthSpec buildSpec();
    public A withSpec(OAuthSpec spec);
    public Boolean hasSpec();
    public OAuthFluent.SpecNested<A> withNewSpec();
    public OAuthFluent.SpecNested<A> withNewSpecLike(OAuthSpec item);
    public OAuthFluent.SpecNested<A> editSpec();
    public OAuthFluent.SpecNested<A> editOrNewSpec();
    public OAuthFluent.SpecNested<A> editOrNewSpecLike(OAuthSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public OAuthStatus getStatus();
    public OAuthStatus buildStatus();
    public A withStatus(OAuthStatus status);
    public Boolean hasStatus();
    public OAuthFluent.StatusNested<A> withNewStatus();
    public OAuthFluent.StatusNested<A> withNewStatusLike(OAuthStatus item);
    public OAuthFluent.StatusNested<A> editStatus();
    public OAuthFluent.StatusNested<A> editOrNewStatus();
    public OAuthFluent.StatusNested<A> editOrNewStatusLike(OAuthStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OAuthFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthSpecFluent<OAuthFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthStatusFluent<OAuthFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
