package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthTemplatesBuilder extends OAuthTemplatesFluentImpl<OAuthTemplatesBuilder> implements VisitableBuilder<OAuthTemplates,OAuthTemplatesBuilder>{

    OAuthTemplatesFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthTemplatesBuilder(){
            this(true);
    }
    public OAuthTemplatesBuilder(Boolean validationEnabled){
            this(new OAuthTemplates(), validationEnabled);
    }
    public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent){
            this(fluent, true);
    }
    public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OAuthTemplates(), validationEnabled);
    }
    public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent,OAuthTemplates instance){
            this(fluent, instance, true);
    }
    public OAuthTemplatesBuilder(OAuthTemplatesFluent<?> fluent,OAuthTemplates instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withError(instance.getError()); 
            fluent.withLogin(instance.getLogin()); 
            fluent.withProviderSelection(instance.getProviderSelection()); 
            this.validationEnabled = validationEnabled; 
    }
    public OAuthTemplatesBuilder(OAuthTemplates instance){
            this(instance,true);
    }
    public OAuthTemplatesBuilder(OAuthTemplates instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withError(instance.getError()); 
            this.withLogin(instance.getLogin()); 
            this.withProviderSelection(instance.getProviderSelection()); 
            this.validationEnabled = validationEnabled; 
    }

    public OAuthTemplates build(){
            OAuthTemplates buildable = new OAuthTemplates(fluent.getError(),fluent.getLogin(),fluent.getProviderSelection());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OAuthTemplatesBuilder that = (OAuthTemplatesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
