package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySubjectReviewSpecBuilder extends PodSecurityPolicySubjectReviewSpecFluentImpl<PodSecurityPolicySubjectReviewSpecBuilder> implements VisitableBuilder<PodSecurityPolicySubjectReviewSpec,PodSecurityPolicySubjectReviewSpecBuilder>{

    PodSecurityPolicySubjectReviewSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicySubjectReviewSpecBuilder(){
            this(true);
    }
    public PodSecurityPolicySubjectReviewSpecBuilder(Boolean validationEnabled){
            this(new PodSecurityPolicySubjectReviewSpec(), validationEnabled);
    }
    public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PodSecurityPolicySubjectReviewSpec(), validationEnabled);
    }
    public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent,PodSecurityPolicySubjectReviewSpec instance){
            this(fluent, instance, true);
    }
    public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent,PodSecurityPolicySubjectReviewSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGroups(instance.getGroups()); 
            fluent.withTemplate(instance.getTemplate()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpec instance){
            this(instance,true);
    }
    public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGroups(instance.getGroups()); 
            this.withTemplate(instance.getTemplate()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySubjectReviewSpec build(){
            PodSecurityPolicySubjectReviewSpec buildable = new PodSecurityPolicySubjectReviewSpec(fluent.getGroups(),fluent.getTemplate(),fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodSecurityPolicySubjectReviewSpecBuilder that = (PodSecurityPolicySubjectReviewSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
