package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ProxyStatusFluentImpl<A extends ProxyStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProxyStatusFluent<A>{

    private String httpProxy;
    private String httpsProxy;
    private String noProxy;

    public ProxyStatusFluentImpl(){
    }
    public ProxyStatusFluentImpl(ProxyStatus instance){
            this.withHttpProxy(instance.getHttpProxy()); 
            this.withHttpsProxy(instance.getHttpsProxy()); 
            this.withNoProxy(instance.getNoProxy()); 
    }

    public String getHttpProxy(){
            return this.httpProxy;
    }

    public A withHttpProxy(String httpProxy){
            this.httpProxy=httpProxy; return (A) this;
    }

    public Boolean hasHttpProxy(){
            return this.httpProxy != null;
    }

    public A withNewHttpProxy(String arg1){
            return (A)withHttpProxy(new String(arg1));
    }

    public A withNewHttpProxy(StringBuilder arg1){
            return (A)withHttpProxy(new String(arg1));
    }

    public A withNewHttpProxy(StringBuffer arg1){
            return (A)withHttpProxy(new String(arg1));
    }

    public String getHttpsProxy(){
            return this.httpsProxy;
    }

    public A withHttpsProxy(String httpsProxy){
            this.httpsProxy=httpsProxy; return (A) this;
    }

    public Boolean hasHttpsProxy(){
            return this.httpsProxy != null;
    }

    public A withNewHttpsProxy(String arg1){
            return (A)withHttpsProxy(new String(arg1));
    }

    public A withNewHttpsProxy(StringBuilder arg1){
            return (A)withHttpsProxy(new String(arg1));
    }

    public A withNewHttpsProxy(StringBuffer arg1){
            return (A)withHttpsProxy(new String(arg1));
    }

    public String getNoProxy(){
            return this.noProxy;
    }

    public A withNoProxy(String noProxy){
            this.noProxy=noProxy; return (A) this;
    }

    public Boolean hasNoProxy(){
            return this.noProxy != null;
    }

    public A withNewNoProxy(String arg1){
            return (A)withNoProxy(new String(arg1));
    }

    public A withNewNoProxy(StringBuilder arg1){
            return (A)withNoProxy(new String(arg1));
    }

    public A withNewNoProxy(StringBuffer arg1){
            return (A)withNoProxy(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ProxyStatusFluentImpl that = (ProxyStatusFluentImpl) o;
            if (httpProxy != null ? !httpProxy.equals(that.httpProxy) :that.httpProxy != null) return false;
            if (httpsProxy != null ? !httpsProxy.equals(that.httpsProxy) :that.httpsProxy != null) return false;
            if (noProxy != null ? !noProxy.equals(that.noProxy) :that.noProxy != null) return false;
            return true;
    }




}
