package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class VSpherePlatformStatusFluentImpl<A extends VSpherePlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VSpherePlatformStatusFluent<A>{

    private String apiServerInternalIP;
    private String ingressIP;
    private String nodeDNSIP;

    public VSpherePlatformStatusFluentImpl(){
    }
    public VSpherePlatformStatusFluentImpl(VSpherePlatformStatus instance){
            this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
            this.withIngressIP(instance.getIngressIP()); 
            this.withNodeDNSIP(instance.getNodeDNSIP()); 
    }

    public String getApiServerInternalIP(){
            return this.apiServerInternalIP;
    }

    public A withApiServerInternalIP(String apiServerInternalIP){
            this.apiServerInternalIP=apiServerInternalIP; return (A) this;
    }

    public Boolean hasApiServerInternalIP(){
            return this.apiServerInternalIP != null;
    }

    public A withNewApiServerInternalIP(String arg1){
            return (A)withApiServerInternalIP(new String(arg1));
    }

    public A withNewApiServerInternalIP(StringBuilder arg1){
            return (A)withApiServerInternalIP(new String(arg1));
    }

    public A withNewApiServerInternalIP(StringBuffer arg1){
            return (A)withApiServerInternalIP(new String(arg1));
    }

    public String getIngressIP(){
            return this.ingressIP;
    }

    public A withIngressIP(String ingressIP){
            this.ingressIP=ingressIP; return (A) this;
    }

    public Boolean hasIngressIP(){
            return this.ingressIP != null;
    }

    public A withNewIngressIP(String arg1){
            return (A)withIngressIP(new String(arg1));
    }

    public A withNewIngressIP(StringBuilder arg1){
            return (A)withIngressIP(new String(arg1));
    }

    public A withNewIngressIP(StringBuffer arg1){
            return (A)withIngressIP(new String(arg1));
    }

    public String getNodeDNSIP(){
            return this.nodeDNSIP;
    }

    public A withNodeDNSIP(String nodeDNSIP){
            this.nodeDNSIP=nodeDNSIP; return (A) this;
    }

    public Boolean hasNodeDNSIP(){
            return this.nodeDNSIP != null;
    }

    public A withNewNodeDNSIP(String arg1){
            return (A)withNodeDNSIP(new String(arg1));
    }

    public A withNewNodeDNSIP(StringBuilder arg1){
            return (A)withNodeDNSIP(new String(arg1));
    }

    public A withNewNodeDNSIP(StringBuffer arg1){
            return (A)withNodeDNSIP(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            VSpherePlatformStatusFluentImpl that = (VSpherePlatformStatusFluentImpl) o;
            if (apiServerInternalIP != null ? !apiServerInternalIP.equals(that.apiServerInternalIP) :that.apiServerInternalIP != null) return false;
            if (ingressIP != null ? !ingressIP.equals(that.ingressIP) :that.ingressIP != null) return false;
            if (nodeDNSIP != null ? !nodeDNSIP.equals(that.nodeDNSIP) :that.nodeDNSIP != null) return false;
            return true;
    }




}
