package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ClusterVersionSpecFluentImpl<A extends ClusterVersionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterVersionSpecFluent<A> {

    private String channel;
    private String clusterID;
    private UpdateBuilder desiredUpdate;
    private List<ComponentOverrideBuilder> overrides =  new ArrayList<ComponentOverrideBuilder>();
    private String upstream;

    public ClusterVersionSpecFluentImpl() { 
    }


    public ClusterVersionSpecFluentImpl(ClusterVersionSpec instance) { 
        this.withChannel(instance.getChannel()); 
        this.withClusterID(instance.getClusterID()); 
        this.withDesiredUpdate(instance.getDesiredUpdate()); 
        this.withOverrides(instance.getOverrides()); 
        this.withUpstream(instance.getUpstream()); 
    }


    public String getChannel() {
        return this.channel;
    }

    public A withChannel(String channel) {
        this.channel=channel; return (A) this;
    }

    public Boolean hasChannel() {
        return this.channel != null;
    }

    public A withNewChannel(String arg1) {
        return (A)withChannel(new String(arg1));
    }

    public A withNewChannel(StringBuilder arg1) {
        return (A)withChannel(new String(arg1));
    }

    public A withNewChannel(StringBuffer arg1) {
        return (A)withChannel(new String(arg1));
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public A withClusterID(String clusterID) {
        this.clusterID=clusterID; return (A) this;
    }

    public Boolean hasClusterID() {
        return this.clusterID != null;
    }

    public A withNewClusterID(String arg1) {
        return (A)withClusterID(new String(arg1));
    }

    public A withNewClusterID(StringBuilder arg1) {
        return (A)withClusterID(new String(arg1));
    }

    public A withNewClusterID(StringBuffer arg1) {
        return (A)withClusterID(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDesiredUpdate instead.
 * @return The buildable object.
 */
@Deprecated public Update getDesiredUpdate() {
        return this.desiredUpdate!=null?this.desiredUpdate.build():null;
    }

    public Update buildDesiredUpdate() {
        return this.desiredUpdate!=null?this.desiredUpdate.build():null;
    }

    public A withDesiredUpdate(Update desiredUpdate) {
        _visitables.get("desiredUpdate").remove(this.desiredUpdate);
        if (desiredUpdate!=null){ this.desiredUpdate= new UpdateBuilder(desiredUpdate); _visitables.get("desiredUpdate").add(this.desiredUpdate);} return (A) this;
    }

    public Boolean hasDesiredUpdate() {
        return this.desiredUpdate != null;
    }

    public A withNewDesiredUpdate(Boolean force,String image,String version) {
        return (A)withDesiredUpdate(new Update(force, image, version));
    }

    public ClusterVersionSpecFluent.DesiredUpdateNested<A> withNewDesiredUpdate() {
        return new DesiredUpdateNestedImpl();
    }

    public ClusterVersionSpecFluent.DesiredUpdateNested<A> withNewDesiredUpdateLike(Update item) {
        return new DesiredUpdateNestedImpl(item);
    }

    public ClusterVersionSpecFluent.DesiredUpdateNested<A> editDesiredUpdate() {
        return withNewDesiredUpdateLike(getDesiredUpdate());
    }

    public ClusterVersionSpecFluent.DesiredUpdateNested<A> editOrNewDesiredUpdate() {
        return withNewDesiredUpdateLike(getDesiredUpdate() != null ? getDesiredUpdate(): new UpdateBuilder().build());
    }

    public ClusterVersionSpecFluent.DesiredUpdateNested<A> editOrNewDesiredUpdateLike(Update item) {
        return withNewDesiredUpdateLike(getDesiredUpdate() != null ? getDesiredUpdate(): item);
    }

    public A addToOverrides(int index,ComponentOverride item) {
        if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
        ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").add(index >= 0 ? index : _visitables.get("overrides").size(), builder);this.overrides.add(index >= 0 ? index : overrides.size(), builder); return (A)this;
    }

    public A setToOverrides(int index,ComponentOverride item) {
        if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
        ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
        if (index < 0 || index >= _visitables.get("overrides").size()) { _visitables.get("overrides").add(builder); } else { _visitables.get("overrides").set(index, builder);}
        if (index < 0 || index >= overrides.size()) { overrides.add(builder); } else { overrides.set(index, builder);}
         return (A)this;
    }

    public A addToOverrides(ComponentOverride... items) {
        if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
        for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A addAllToOverrides(Collection<ComponentOverride> items) {
        if (this.overrides == null) {this.overrides = new ArrayList<ComponentOverrideBuilder>();}
        for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A removeFromOverrides(ComponentOverride... items) {
        for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    public A removeAllFromOverrides(Collection<ComponentOverride> items) {
        for (ComponentOverride item : items) {ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOverrides(io.fabric8.kubernetes.api.builder.Predicate<ComponentOverrideBuilder> predicate) {
        if (overrides == null) return (A) this;
        final Iterator<ComponentOverrideBuilder> each = overrides.iterator();
        final List visitables = _visitables.get("overrides");
        while (each.hasNext()) {
          ComponentOverrideBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOverrides instead.
 * @return The buildable object.
 */
@Deprecated public List<ComponentOverride> getOverrides() {
        return build(overrides);
    }

    public List<ComponentOverride> buildOverrides() {
        return build(overrides);
    }

    public ComponentOverride buildOverride(int index) {
        return this.overrides.get(index).build();
    }

    public ComponentOverride buildFirstOverride() {
        return this.overrides.get(0).build();
    }

    public ComponentOverride buildLastOverride() {
        return this.overrides.get(overrides.size() - 1).build();
    }

    public ComponentOverride buildMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<ComponentOverrideBuilder> predicate) {
        for (ComponentOverrideBuilder item: overrides) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<ComponentOverrideBuilder> predicate) {
        for (ComponentOverrideBuilder item: overrides) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withOverrides(List<ComponentOverride> overrides) {
        if (this.overrides != null) { _visitables.get("overrides").removeAll(this.overrides);}
        if (overrides != null) {this.overrides = new ArrayList<ComponentOverrideBuilder>(); for (ComponentOverride item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
    }

    public A withOverrides(ComponentOverride... overrides) {
        if (this.overrides != null) {this.overrides.clear();}
        if (overrides != null) {for (ComponentOverride item :overrides){ this.addToOverrides(item);}} return (A) this;
    }

    public Boolean hasOverrides() {
        return overrides != null && !overrides.isEmpty();
    }

    public A addNewOverride(String group,String kind,String name,String namespace,Boolean unmanaged) {
        return (A)addToOverrides(new ComponentOverride(group, kind, name, namespace, unmanaged));
    }

    public ClusterVersionSpecFluent.OverridesNested<A> addNewOverride() {
        return new OverridesNestedImpl();
    }

    public ClusterVersionSpecFluent.OverridesNested<A> addNewOverrideLike(ComponentOverride item) {
        return new OverridesNestedImpl(-1, item);
    }

    public ClusterVersionSpecFluent.OverridesNested<A> setNewOverrideLike(int index,ComponentOverride item) {
        return new OverridesNestedImpl(index, item);
    }

    public ClusterVersionSpecFluent.OverridesNested<A> editOverride(int index) {
        if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
        return setNewOverrideLike(index, buildOverride(index));
    }

    public ClusterVersionSpecFluent.OverridesNested<A> editFirstOverride() {
        if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
        return setNewOverrideLike(0, buildOverride(0));
    }

    public ClusterVersionSpecFluent.OverridesNested<A> editLastOverride() {
        int index = overrides.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
        return setNewOverrideLike(index, buildOverride(index));
    }

    public ClusterVersionSpecFluent.OverridesNested<A> editMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<ComponentOverrideBuilder> predicate) {
        int index = -1;
        for (int i=0;i<overrides.size();i++) { 
        if (predicate.apply(overrides.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
        return setNewOverrideLike(index, buildOverride(index));
    }

    public String getUpstream() {
        return this.upstream;
    }

    public A withUpstream(String upstream) {
        this.upstream=upstream; return (A) this;
    }

    public Boolean hasUpstream() {
        return this.upstream != null;
    }

    public A withNewUpstream(String arg1) {
        return (A)withUpstream(new String(arg1));
    }

    public A withNewUpstream(StringBuilder arg1) {
        return (A)withUpstream(new String(arg1));
    }

    public A withNewUpstream(StringBuffer arg1) {
        return (A)withUpstream(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterVersionSpecFluentImpl that = (ClusterVersionSpecFluentImpl) o;
        if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
        if (clusterID != null ? !clusterID.equals(that.clusterID) :that.clusterID != null) return false;
        if (desiredUpdate != null ? !desiredUpdate.equals(that.desiredUpdate) :that.desiredUpdate != null) return false;
        if (overrides != null ? !overrides.equals(that.overrides) :that.overrides != null) return false;
        if (upstream != null ? !upstream.equals(that.upstream) :that.upstream != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channel,  clusterID,  desiredUpdate,  overrides,  upstream,  super.hashCode());
    }

    public class DesiredUpdateNestedImpl<N> extends UpdateFluentImpl<ClusterVersionSpecFluent.DesiredUpdateNested<N>> implements ClusterVersionSpecFluent.DesiredUpdateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final UpdateBuilder builder;

        DesiredUpdateNestedImpl(Update item) {
            this.builder = new UpdateBuilder(this, item);
        }

        DesiredUpdateNestedImpl() {
            this.builder = new UpdateBuilder(this);
        }

        public N and() {
             return (N) ClusterVersionSpecFluentImpl.this.withDesiredUpdate(builder.build());
        }

        public N endDesiredUpdate() {
             return and();
        }
    }


    public class OverridesNestedImpl<N> extends ComponentOverrideFluentImpl<ClusterVersionSpecFluent.OverridesNested<N>> implements ClusterVersionSpecFluent.OverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentOverrideBuilder builder;
        private final int index;

        OverridesNestedImpl(int index,ComponentOverride item) {
            this.index = index;
            this.builder = new ComponentOverrideBuilder(this, item);
        }

        OverridesNestedImpl() {
            this.index = -1;
            this.builder = new ComponentOverrideBuilder(this);
        }

        public N and() {
             return (N) ClusterVersionSpecFluentImpl.this.setToOverrides(index,builder.build());
        }

        public N endOverride() {
             return and();
        }
    }


}
