package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KeystoneIdentityProviderFluentImpl<A extends KeystoneIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KeystoneIdentityProviderFluent<A> {

    private ConfigMapNameReferenceBuilder ca;
    private String domainName;
    private SecretNameReferenceBuilder tlsClientCert;
    private SecretNameReferenceBuilder tlsClientKey;
    private String url;

    public KeystoneIdentityProviderFluentImpl() { 
    }


    public KeystoneIdentityProviderFluentImpl(KeystoneIdentityProvider instance) { 
        this.withCa(instance.getCa()); 
        this.withDomainName(instance.getDomainName()); 
        this.withTlsClientCert(instance.getTlsClientCert()); 
        this.withTlsClientKey(instance.getTlsClientKey()); 
        this.withUrl(instance.getUrl()); 
    }


    
/**
 * This method has been deprecated, please use method buildCa instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public ConfigMapNameReference buildCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public A withCa(ConfigMapNameReference ca) {
        _visitables.get("ca").remove(this.ca);
        if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public Boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(String name) {
        return (A)withCa(new ConfigMapNameReference(name));
    }

    public KeystoneIdentityProviderFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    public KeystoneIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNestedImpl(item);
    }

    public KeystoneIdentityProviderFluent.CaNested<A> editCa() {
        return withNewCaLike(getCa());
    }

    public KeystoneIdentityProviderFluent.CaNested<A> editOrNewCa() {
        return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
    }

    public KeystoneIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public A withDomainName(String domainName) {
        this.domainName=domainName; return (A) this;
    }

    public Boolean hasDomainName() {
        return this.domainName != null;
    }

    public A withNewDomainName(String arg1) {
        return (A)withDomainName(new String(arg1));
    }

    public A withNewDomainName(StringBuilder arg1) {
        return (A)withDomainName(new String(arg1));
    }

    public A withNewDomainName(StringBuffer arg1) {
        return (A)withDomainName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTlsClientCert instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getTlsClientCert() {
        return this.tlsClientCert!=null?this.tlsClientCert.build():null;
    }

    public SecretNameReference buildTlsClientCert() {
        return this.tlsClientCert!=null?this.tlsClientCert.build():null;
    }

    public A withTlsClientCert(SecretNameReference tlsClientCert) {
        _visitables.get("tlsClientCert").remove(this.tlsClientCert);
        if (tlsClientCert!=null){ this.tlsClientCert= new SecretNameReferenceBuilder(tlsClientCert); _visitables.get("tlsClientCert").add(this.tlsClientCert);} return (A) this;
    }

    public Boolean hasTlsClientCert() {
        return this.tlsClientCert != null;
    }

    public A withNewTlsClientCert(String name) {
        return (A)withTlsClientCert(new SecretNameReference(name));
    }

    public KeystoneIdentityProviderFluent.TlsClientCertNested<A> withNewTlsClientCert() {
        return new TlsClientCertNestedImpl();
    }

    public KeystoneIdentityProviderFluent.TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item) {
        return new TlsClientCertNestedImpl(item);
    }

    public KeystoneIdentityProviderFluent.TlsClientCertNested<A> editTlsClientCert() {
        return withNewTlsClientCertLike(getTlsClientCert());
    }

    public KeystoneIdentityProviderFluent.TlsClientCertNested<A> editOrNewTlsClientCert() {
        return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): new SecretNameReferenceBuilder().build());
    }

    public KeystoneIdentityProviderFluent.TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item) {
        return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsClientKey instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getTlsClientKey() {
        return this.tlsClientKey!=null?this.tlsClientKey.build():null;
    }

    public SecretNameReference buildTlsClientKey() {
        return this.tlsClientKey!=null?this.tlsClientKey.build():null;
    }

    public A withTlsClientKey(SecretNameReference tlsClientKey) {
        _visitables.get("tlsClientKey").remove(this.tlsClientKey);
        if (tlsClientKey!=null){ this.tlsClientKey= new SecretNameReferenceBuilder(tlsClientKey); _visitables.get("tlsClientKey").add(this.tlsClientKey);} return (A) this;
    }

    public Boolean hasTlsClientKey() {
        return this.tlsClientKey != null;
    }

    public A withNewTlsClientKey(String name) {
        return (A)withTlsClientKey(new SecretNameReference(name));
    }

    public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> withNewTlsClientKey() {
        return new TlsClientKeyNestedImpl();
    }

    public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> withNewTlsClientKeyLike(SecretNameReference item) {
        return new TlsClientKeyNestedImpl(item);
    }

    public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> editTlsClientKey() {
        return withNewTlsClientKeyLike(getTlsClientKey());
    }

    public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> editOrNewTlsClientKey() {
        return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): new SecretNameReferenceBuilder().build());
    }

    public KeystoneIdentityProviderFluent.TlsClientKeyNested<A> editOrNewTlsClientKeyLike(SecretNameReference item) {
        return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): item);
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KeystoneIdentityProviderFluentImpl that = (KeystoneIdentityProviderFluentImpl) o;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (domainName != null ? !domainName.equals(that.domainName) :that.domainName != null) return false;
        if (tlsClientCert != null ? !tlsClientCert.equals(that.tlsClientCert) :that.tlsClientCert != null) return false;
        if (tlsClientKey != null ? !tlsClientKey.equals(that.tlsClientKey) :that.tlsClientKey != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ca,  domainName,  tlsClientCert,  tlsClientKey,  url,  super.hashCode());
    }

    public class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<KeystoneIdentityProviderFluent.CaNested<N>> implements KeystoneIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapNameReferenceBuilder builder;

        CaNestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        CaNestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        public N and() {
             return (N) KeystoneIdentityProviderFluentImpl.this.withCa(builder.build());
        }

        public N endCa() {
             return and();
        }
    }


    public class TlsClientCertNestedImpl<N> extends SecretNameReferenceFluentImpl<KeystoneIdentityProviderFluent.TlsClientCertNested<N>> implements KeystoneIdentityProviderFluent.TlsClientCertNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

        TlsClientCertNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        TlsClientCertNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        public N and() {
             return (N) KeystoneIdentityProviderFluentImpl.this.withTlsClientCert(builder.build());
        }

        public N endTlsClientCert() {
             return and();
        }
    }


    public class TlsClientKeyNestedImpl<N> extends SecretNameReferenceFluentImpl<KeystoneIdentityProviderFluent.TlsClientKeyNested<N>> implements KeystoneIdentityProviderFluent.TlsClientKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

        TlsClientKeyNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        TlsClientKeyNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        public N and() {
             return (N) KeystoneIdentityProviderFluentImpl.this.withTlsClientKey(builder.build());
        }

        public N endTlsClientKey() {
             return and();
        }
    }


}
