package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySubjectReviewStatusFluentImpl<A extends PodSecurityPolicySubjectReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSecurityPolicySubjectReviewStatusFluent<A> {

    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder allowedBy;
    private String reason;
    private PodTemplateSpecBuilder template;

    public PodSecurityPolicySubjectReviewStatusFluentImpl() { 
    }


    public PodSecurityPolicySubjectReviewStatusFluentImpl(PodSecurityPolicySubjectReviewStatus instance) { 
        this.withAllowedBy(instance.getAllowedBy()); 
        this.withReason(instance.getReason()); 
        this.withTemplate(instance.getTemplate()); 
    }


    
/**
 * This method has been deprecated, please use method buildAllowedBy instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getAllowedBy() {
        return this.allowedBy!=null?this.allowedBy.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildAllowedBy() {
        return this.allowedBy!=null?this.allowedBy.build():null;
    }

    public A withAllowedBy(io.fabric8.kubernetes.api.model.ObjectReference allowedBy) {
        _visitables.get("allowedBy").remove(this.allowedBy);
        if (allowedBy!=null){ this.allowedBy= new ObjectReferenceBuilder(allowedBy); _visitables.get("allowedBy").add(this.allowedBy);} return (A) this;
    }

    public Boolean hasAllowedBy() {
        return this.allowedBy != null;
    }

    public PodSecurityPolicySubjectReviewStatusFluent.AllowedByNested<A> withNewAllowedBy() {
        return new AllowedByNestedImpl();
    }

    public PodSecurityPolicySubjectReviewStatusFluent.AllowedByNested<A> withNewAllowedByLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new AllowedByNestedImpl(item);
    }

    public PodSecurityPolicySubjectReviewStatusFluent.AllowedByNested<A> editAllowedBy() {
        return withNewAllowedByLike(getAllowedBy());
    }

    public PodSecurityPolicySubjectReviewStatusFluent.AllowedByNested<A> editOrNewAllowedBy() {
        return withNewAllowedByLike(getAllowedBy() != null ? getAllowedBy(): new ObjectReferenceBuilder().build());
    }

    public PodSecurityPolicySubjectReviewStatusFluent.AllowedByNested<A> editOrNewAllowedByLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewAllowedByLike(getAllowedBy() != null ? getAllowedBy(): item);
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason=reason; return (A) this;
    }

    public Boolean hasReason() {
        return this.reason != null;
    }

    public A withNewReason(String arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1) {
        return (A)withReason(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate() {
        return this.template != null;
    }

    public PodSecurityPolicySubjectReviewStatusFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    public PodSecurityPolicySubjectReviewStatusFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    public PodSecurityPolicySubjectReviewStatusFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public PodSecurityPolicySubjectReviewStatusFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public PodSecurityPolicySubjectReviewStatusFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityPolicySubjectReviewStatusFluentImpl that = (PodSecurityPolicySubjectReviewStatusFluentImpl) o;
        if (allowedBy != null ? !allowedBy.equals(that.allowedBy) :that.allowedBy != null) return false;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowedBy,  reason,  template,  super.hashCode());
    }

    public class AllowedByNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<PodSecurityPolicySubjectReviewStatusFluent.AllowedByNested<N>> implements PodSecurityPolicySubjectReviewStatusFluent.AllowedByNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

        AllowedByNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        AllowedByNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) PodSecurityPolicySubjectReviewStatusFluentImpl.this.withAllowedBy(builder.build());
        }

        public N endAllowedBy() {
             return and();
        }
    }


    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<PodSecurityPolicySubjectReviewStatusFluent.TemplateNested<N>> implements PodSecurityPolicySubjectReviewStatusFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        public N and() {
             return (N) PodSecurityPolicySubjectReviewStatusFluentImpl.this.withTemplate(builder.build());
        }

        public N endTemplate() {
             return and();
        }
    }


}
