package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AuditFluentImpl<A extends AuditFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AuditFluent<A> {

    private String profile;

    public AuditFluentImpl() { 
    }


    public AuditFluentImpl(Audit instance) { 
        this.withProfile(instance.getProfile()); 
    }


    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile=profile; return (A) this;
    }

    public Boolean hasProfile() {
        return this.profile != null;
    }

    public A withNewProfile(String arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(StringBuilder arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(StringBuffer arg1) {
        return (A)withProfile(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AuditFluentImpl that = (AuditFluentImpl) o;
        if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(profile,  super.hashCode());
    }

}
