package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class AWSPlatformSpecFluentImpl<A extends AWSPlatformSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AWSPlatformSpecFluent<A> {

    private List<AWSServiceEndpointBuilder> serviceEndpoints =  new ArrayList<AWSServiceEndpointBuilder>();

    public AWSPlatformSpecFluentImpl() { 
    }


    public AWSPlatformSpecFluentImpl(AWSPlatformSpec instance) { 
        this.withServiceEndpoints(instance.getServiceEndpoints()); 
    }


    public A addToServiceEndpoints(int index,AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(index >= 0 ? index : _visitables.get("serviceEndpoints").size(), builder);this.serviceEndpoints.add(index >= 0 ? index : serviceEndpoints.size(), builder); return (A)this;
    }

    public A setToServiceEndpoints(int index,AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= _visitables.get("serviceEndpoints").size()) { _visitables.get("serviceEndpoints").add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder);}
        if (index < 0 || index >= serviceEndpoints.size()) { serviceEndpoints.add(builder); } else { serviceEndpoints.set(index, builder);}
         return (A)this;
    }

    public A addToServiceEndpoints(AWSServiceEndpoint... items) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
    }

    public A removeFromServiceEndpoints(AWSServiceEndpoint... items) {
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromServiceEndpoints(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate) {
        if (serviceEndpoints == null) return (A) this;
        final Iterator<AWSServiceEndpointBuilder> each = serviceEndpoints.iterator();
        final List visitables = _visitables.get("serviceEndpoints");
        while (each.hasNext()) {
          AWSServiceEndpointBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildServiceEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<AWSServiceEndpoint> getServiceEndpoints() {
        return build(serviceEndpoints);
    }

    public List<AWSServiceEndpoint> buildServiceEndpoints() {
        return build(serviceEndpoints);
    }

    public AWSServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public AWSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public AWSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
    }

    public AWSServiceEndpoint buildMatchingServiceEndpoint(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingServiceEndpoint(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").removeAll(this.serviceEndpoints);}
        if (serviceEndpoints != null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>(); for (AWSServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
    }

    public A withServiceEndpoints(AWSServiceEndpoint... serviceEndpoints) {
        if (this.serviceEndpoints != null) {this.serviceEndpoints.clear();}
        if (serviceEndpoints != null) {for (AWSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
    }

    public Boolean hasServiceEndpoints() {
        return serviceEndpoints != null && !serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name,String url) {
        return (A)addToServiceEndpoints(new AWSServiceEndpoint(name, url));
    }

    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNestedImpl();
    }

    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(-1, item);
    }

    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(index, item);
    }

    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
    }

    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
    }

    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = serviceEndpoints.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
    }

    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(io.fabric8.kubernetes.api.builder.Predicate<AWSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i=0;i<serviceEndpoints.size();i++) { 
        if (predicate.apply(serviceEndpoints.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AWSPlatformSpecFluentImpl that = (AWSPlatformSpecFluentImpl) o;
        if (serviceEndpoints != null ? !serviceEndpoints.equals(that.serviceEndpoints) :that.serviceEndpoints != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(serviceEndpoints,  super.hashCode());
    }

    public class ServiceEndpointsNestedImpl<N> extends AWSServiceEndpointFluentImpl<AWSPlatformSpecFluent.ServiceEndpointsNested<N>> implements AWSPlatformSpecFluent.ServiceEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSServiceEndpointBuilder builder;
        private final int index;

        ServiceEndpointsNestedImpl(int index,AWSServiceEndpoint item) {
            this.index = index;
            this.builder = new AWSServiceEndpointBuilder(this, item);
        }

        ServiceEndpointsNestedImpl() {
            this.index = -1;
            this.builder = new AWSServiceEndpointBuilder(this);
        }

        public N and() {
             return (N) AWSPlatformSpecFluentImpl.this.setToServiceEndpoints(index,builder.build());
        }

        public N endServiceEndpoint() {
             return and();
        }
    }


}
