package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageSignatureBuilder extends ImageSignatureFluentImpl<ImageSignatureBuilder> implements VisitableBuilder<ImageSignature,ImageSignatureBuilder> {

    ImageSignatureFluent<?> fluent;
    Boolean validationEnabled;

    public ImageSignatureBuilder() { 
        this(true);
    }


    public ImageSignatureBuilder(Boolean validationEnabled) { 
        this(new ImageSignature(), validationEnabled);
    }


    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent) { 
        this(fluent, true);
    }


    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ImageSignature(), validationEnabled);
    }


    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent,ImageSignature instance) { 
        this(fluent, instance, true);
    }


    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent,ImageSignature instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withContent(instance.getContent()); 
        fluent.withCreated(instance.getCreated()); 
        fluent.withImageIdentity(instance.getImageIdentity()); 
        fluent.withIssuedBy(instance.getIssuedBy()); 
        fluent.withIssuedTo(instance.getIssuedTo()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSignedClaims(instance.getSignedClaims()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public ImageSignatureBuilder(ImageSignature instance) { 
        this(instance,true);
    }


    public ImageSignatureBuilder(ImageSignature instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withConditions(instance.getConditions()); 
        this.withContent(instance.getContent()); 
        this.withCreated(instance.getCreated()); 
        this.withImageIdentity(instance.getImageIdentity()); 
        this.withIssuedBy(instance.getIssuedBy()); 
        this.withIssuedTo(instance.getIssuedTo()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSignedClaims(instance.getSignedClaims()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public ImageSignature build() {
        ImageSignature buildable = new ImageSignature(fluent.getApiVersion(),fluent.getConditions(),fluent.getContent(),fluent.getCreated(),fluent.getImageIdentity(),fluent.getIssuedBy(),fluent.getIssuedTo(),fluent.getKind(),fluent.getMetadata(),fluent.getSignedClaims(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageSignatureBuilder that = (ImageSignatureBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
