package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RepositoryImportStatusBuilder extends RepositoryImportStatusFluentImpl<RepositoryImportStatusBuilder> implements VisitableBuilder<RepositoryImportStatus,RepositoryImportStatusBuilder> {

    RepositoryImportStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RepositoryImportStatusBuilder() { 
        this(true);
    }


    public RepositoryImportStatusBuilder(Boolean validationEnabled) { 
        this(new RepositoryImportStatus(), validationEnabled);
    }


    public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new RepositoryImportStatus(), validationEnabled);
    }


    public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent,RepositoryImportStatus instance) { 
        this(fluent, instance, true);
    }


    public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent,RepositoryImportStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAdditionalTags(instance.getAdditionalTags()); 
        fluent.withImages(instance.getImages()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public RepositoryImportStatusBuilder(RepositoryImportStatus instance) { 
        this(instance,true);
    }


    public RepositoryImportStatusBuilder(RepositoryImportStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAdditionalTags(instance.getAdditionalTags()); 
        this.withImages(instance.getImages()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public RepositoryImportStatus build() {
        RepositoryImportStatus buildable = new RepositoryImportStatus(fluent.getAdditionalTags(),fluent.getImages(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RepositoryImportStatusBuilder that = (RepositoryImportStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
