package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AzurePlatformStatusBuilder extends AzurePlatformStatusFluentImpl<AzurePlatformStatusBuilder> implements VisitableBuilder<AzurePlatformStatus,AzurePlatformStatusBuilder> {

    AzurePlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public AzurePlatformStatusBuilder() { 
        this(true);
    }


    public AzurePlatformStatusBuilder(Boolean validationEnabled) { 
        this(new AzurePlatformStatus(), validationEnabled);
    }


    public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AzurePlatformStatus(), validationEnabled);
    }


    public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent,AzurePlatformStatus instance) { 
        this(fluent, instance, true);
    }


    public AzurePlatformStatusBuilder(AzurePlatformStatusFluent<?> fluent,AzurePlatformStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCloudName(instance.getCloudName()); 
        fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
        fluent.withResourceGroupName(instance.getResourceGroupName()); 
        this.validationEnabled = validationEnabled; 
    }


    public AzurePlatformStatusBuilder(AzurePlatformStatus instance) { 
        this(instance,true);
    }


    public AzurePlatformStatusBuilder(AzurePlatformStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCloudName(instance.getCloudName()); 
        this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
        this.withResourceGroupName(instance.getResourceGroupName()); 
        this.validationEnabled = validationEnabled; 
    }


    public AzurePlatformStatus build() {
        AzurePlatformStatus buildable = new AzurePlatformStatus(fluent.getCloudName(),fluent.getNetworkResourceGroupName(),fluent.getResourceGroupName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AzurePlatformStatusBuilder that = (AzurePlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
