package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HubSourceBuilder extends HubSourceFluentImpl<HubSourceBuilder> implements VisitableBuilder<HubSource,HubSourceBuilder> {

    HubSourceFluent<?> fluent;
    Boolean validationEnabled;

    public HubSourceBuilder() { 
        this(true);
    }


    public HubSourceBuilder(Boolean validationEnabled) { 
        this(new HubSource(), validationEnabled);
    }


    public HubSourceBuilder(HubSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public HubSourceBuilder(HubSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new HubSource(), validationEnabled);
    }


    public HubSourceBuilder(HubSourceFluent<?> fluent,HubSource instance) { 
        this(fluent, instance, true);
    }


    public HubSourceBuilder(HubSourceFluent<?> fluent,HubSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDisabled(instance.getDisabled()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public HubSourceBuilder(HubSource instance) { 
        this(instance,true);
    }


    public HubSourceBuilder(HubSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDisabled(instance.getDisabled()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }


    public HubSource build() {
        HubSource buildable = new HubSource(fluent.isDisabled(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HubSourceBuilder that = (HubSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
