package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySubjectReviewStatusBuilder extends PodSecurityPolicySubjectReviewStatusFluentImpl<PodSecurityPolicySubjectReviewStatusBuilder> implements VisitableBuilder<PodSecurityPolicySubjectReviewStatus,PodSecurityPolicySubjectReviewStatusBuilder> {

    PodSecurityPolicySubjectReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicySubjectReviewStatusBuilder() { 
        this(true);
    }


    public PodSecurityPolicySubjectReviewStatusBuilder(Boolean validationEnabled) { 
        this(new PodSecurityPolicySubjectReviewStatus(), validationEnabled);
    }


    public PodSecurityPolicySubjectReviewStatusBuilder(PodSecurityPolicySubjectReviewStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public PodSecurityPolicySubjectReviewStatusBuilder(PodSecurityPolicySubjectReviewStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PodSecurityPolicySubjectReviewStatus(), validationEnabled);
    }


    public PodSecurityPolicySubjectReviewStatusBuilder(PodSecurityPolicySubjectReviewStatusFluent<?> fluent,PodSecurityPolicySubjectReviewStatus instance) { 
        this(fluent, instance, true);
    }


    public PodSecurityPolicySubjectReviewStatusBuilder(PodSecurityPolicySubjectReviewStatusFluent<?> fluent,PodSecurityPolicySubjectReviewStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAllowedBy(instance.getAllowedBy()); 
        fluent.withReason(instance.getReason()); 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodSecurityPolicySubjectReviewStatusBuilder(PodSecurityPolicySubjectReviewStatus instance) { 
        this(instance,true);
    }


    public PodSecurityPolicySubjectReviewStatusBuilder(PodSecurityPolicySubjectReviewStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAllowedBy(instance.getAllowedBy()); 
        this.withReason(instance.getReason()); 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodSecurityPolicySubjectReviewStatus build() {
        PodSecurityPolicySubjectReviewStatus buildable = new PodSecurityPolicySubjectReviewStatus(fluent.getAllowedBy(),fluent.getReason(),fluent.getTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityPolicySubjectReviewStatusBuilder that = (PodSecurityPolicySubjectReviewStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
