
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "accessTokenInactivityTimeout",
    "accessTokenInactivityTimeoutSeconds",
    "accessTokenMaxAgeSeconds"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class TokenConfig implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("accessTokenInactivityTimeout")
    private Duration accessTokenInactivityTimeout;
    /**
     * 
     * 
     */
    @JsonProperty("accessTokenInactivityTimeoutSeconds")
    private Integer accessTokenInactivityTimeoutSeconds;
    /**
     * 
     * 
     */
    @JsonProperty("accessTokenMaxAgeSeconds")
    private Integer accessTokenMaxAgeSeconds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TokenConfig() {
    }

    /**
     * 
     * @param accessTokenInactivityTimeoutSeconds
     * @param accessTokenMaxAgeSeconds
     * @param accessTokenInactivityTimeout
     */
    public TokenConfig(Duration accessTokenInactivityTimeout, Integer accessTokenInactivityTimeoutSeconds, Integer accessTokenMaxAgeSeconds) {
        this.accessTokenInactivityTimeout = accessTokenInactivityTimeout;
        this.accessTokenInactivityTimeoutSeconds = accessTokenInactivityTimeoutSeconds;
        this.accessTokenMaxAgeSeconds = accessTokenMaxAgeSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The accessTokenInactivityTimeout
     */
    @JsonProperty("accessTokenInactivityTimeout")
    public Duration getAccessTokenInactivityTimeout() {
        return accessTokenInactivityTimeout;
    }

    /**
     * 
     * 
     * @param accessTokenInactivityTimeout
     *     The accessTokenInactivityTimeout
     */
    @JsonProperty("accessTokenInactivityTimeout")
    public void setAccessTokenInactivityTimeout(Duration accessTokenInactivityTimeout) {
        this.accessTokenInactivityTimeout = accessTokenInactivityTimeout;
    }

    /**
     * 
     * 
     * @return
     *     The accessTokenInactivityTimeoutSeconds
     */
    @JsonProperty("accessTokenInactivityTimeoutSeconds")
    public Integer getAccessTokenInactivityTimeoutSeconds() {
        return accessTokenInactivityTimeoutSeconds;
    }

    /**
     * 
     * 
     * @param accessTokenInactivityTimeoutSeconds
     *     The accessTokenInactivityTimeoutSeconds
     */
    @JsonProperty("accessTokenInactivityTimeoutSeconds")
    public void setAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds) {
        this.accessTokenInactivityTimeoutSeconds = accessTokenInactivityTimeoutSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The accessTokenMaxAgeSeconds
     */
    @JsonProperty("accessTokenMaxAgeSeconds")
    public Integer getAccessTokenMaxAgeSeconds() {
        return accessTokenMaxAgeSeconds;
    }

    /**
     * 
     * 
     * @param accessTokenMaxAgeSeconds
     *     The accessTokenMaxAgeSeconds
     */
    @JsonProperty("accessTokenMaxAgeSeconds")
    public void setAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds) {
        this.accessTokenMaxAgeSeconds = accessTokenMaxAgeSeconds;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
